/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class WaitInLoop
extends BytecodeScanningDetector
implements Constants2 {
    boolean sawWait = false;
    boolean waitHasTimeout = false;
    boolean sawNotify = false;
    int notifyPC;
    int earliestJump = 0;
    int waitAt = 0;
    private BugReporter bugReporter;

    public WaitInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.sawWait = false;
        this.waitHasTimeout = false;
        this.sawNotify = false;
        this.earliestJump = 9999999;
        super.visit(obj);
        if (this.sawWait && this.waitAt < this.earliestJump) {
            this.bugReporter.reportBug(new BugInstance("WA_NOT_IN_LOOP", this.waitHasTimeout ? 3 : 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, this.waitAt));
        }
        if (this.sawNotify) {
            this.bugReporter.reportBug(new BugInstance("NO_NOTIFY_NOT_NOTIFYALL", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, this.notifyPC));
        }
    }

    public void sawOpcode(int seen) {
        if ((seen == 182 || seen == 185) && this.getNameConstantOperand().equals("notify") && this.getSigConstantOperand().equals("()V")) {
            this.sawNotify = true;
            this.notifyPC = this.getPC();
        }
        if (!this.sawWait && (seen == 182 || seen == 185) && this.getNameConstantOperand().equals("wait") && (this.getSigConstantOperand().equals("()V") || this.getSigConstantOperand().equals("(J)V") || this.getSigConstantOperand().equals("(JI)V"))) {
            this.sawWait = true;
            this.waitHasTimeout = !this.getSigConstantOperand().equals("()V");
            this.waitAt = this.getPC();
            this.earliestJump = this.getPC() + 1;
            return;
        }
        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
            this.earliestJump = Math.min(this.earliestJump, this.getBranchTarget());
        }
    }
}

