/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumberTable;

public class SwitchFallthrough
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("switchFallthrough.debug");
    int nextIndex = -1;
    boolean reachable = false;
    boolean inSwitch = false;
    int start;
    int switchPC;
    private BugReporter bugReporter;
    LineNumberTable lineNumbers;

    public SwitchFallthrough(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
    }

    public void visit(Code obj) {
        this.inSwitch = false;
        this.reachable = true;
        this.lineNumbers = obj.getLineNumberTable();
        if (this.lineNumbers != null) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        int[] switchOffsets = null;
        int[] switchLabels = null;
        switch (seen) {
            case 170: 
            case 171: {
                this.switchPC = this.getPC();
                switchOffsets = this.getSwitchOffsets();
                switchLabels = this.getSwitchLabels();
                this.inSwitch = true;
                this.reachable = false;
                this.nextIndex = 0;
                break;
            }
        }
        if (this.inSwitch && this.nextIndex >= switchOffsets.length) {
            this.inSwitch = false;
        }
        if (this.inSwitch && this.getPC() == this.switchPC + switchOffsets[this.nextIndex] && switchOffsets[this.nextIndex] != this.getDefaultSwitchOffset()) {
            if (this.nextIndex > 0 && this.reachable) {
                int endOfPreviousCase = this.lineNumbers.getSourceLine(this.getPC() - 1);
                int startOfNextCase = this.lineNumbers.getSourceLine(this.getPC());
                int previousLabel = switchLabels[this.nextIndex - 1];
                int nextLabel = switchLabels[this.nextIndex];
                if (!(previousLabel == 10 && nextLabel == 13 || previousLabel == 13 && nextLabel == 10 || startOfNextCase - endOfPreviousCase > 2)) {
                    System.out.println("Reached the switch for " + switchLabels[this.nextIndex] + " at line number " + startOfNextCase + " in " + this.getFullyQualifiedMethodName());
                }
            }
            do {
                ++this.nextIndex;
                if (this.nextIndex < switchOffsets.length) continue;
                this.inSwitch = false;
                break;
            } while (this.getPC() == this.switchPC + switchOffsets[this.nextIndex]);
        }
        switch (seen) {
            case 167: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                this.reachable = false;
                break;
            }
            default: {
                this.reachable = true;
            }
        }
    }
}

