/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Naming
extends PreorderVisitor
implements Detector,
Constants2 {
    String baseClassName;
    HashMap<String, HashSet<String>> canonicalToTrueMapping = new HashMap();
    HashMap<String, HashSet<MyMethod>> canonicalToMyMethod = new HashMap();
    HashSet<String> visited = new HashSet();
    private BugReporter bugReporter;

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            try {
                MyMethod m3;
                boolean r;
                if (!m.confusingMethodNames(m2) || !Repository.instanceOf((JavaClass)m.clazz, (JavaClass)m2.clazz) || (r = others.contains(m3 = new MyMethod(m.clazz, m2.methodName, m.methodSig)))) continue;
                this.bugReporter.reportBug(new BugInstance("NM_VERY_CONFUSING", 1).addClass(m.getClassName()).addMethod(m.getClassName(), m.methodName, m.methodSig).addClass(m2.getClassName()).addMethod(m2.getClassName(), m2.methodName, m2.methodSig));
                return true;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return false;
    }

    private boolean checkNonSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            if (!m.confusingMethodNames(m2)) continue;
            this.bugReporter.reportBug(new BugInstance("NM_CONFUSING", 3).addClass(m.getClassName()).addMethod(m.getClassName(), m.methodName, m.methodSig).addClass(m2.getClassName()).addMethod(m2.getClassName(), m2.methodName, m2.methodSig));
            return true;
        }
        return false;
    }

    public void report() {
        for (Map.Entry<String, HashSet<String>> e : this.canonicalToTrueMapping.entrySet()) {
            HashSet<String> s = e.getValue();
            if (s.size() <= 1) continue;
            String allSmall = e.getKey();
            HashSet<MyMethod> conflictingMethods = this.canonicalToMyMethod.get(allSmall);
            Iterator<MyMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            j = conflictingMethods.iterator();
            while (j.hasNext() && !this.checkNonSuper(j.next(), conflictingMethods)) {
            }
        }
    }

    public void visitJavaClass(JavaClass obj) {
        if (obj.isInterface()) {
            return;
        }
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        try {
            JavaClass[] supers = Repository.getSuperClasses((JavaClass)obj);
            for (int i = 0; i < supers.length; ++i) {
                JavaClass sup = supers[i];
                this.visitJavaClass(supers[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        super.visitJavaClass(obj);
    }

    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$+.]");
        this.baseClassName = parts[parts.length - 1];
        super.visit(obj);
    }

    public void visit(Method obj) {
        if (obj.isAbstract()) {
            return;
        }
        if (this.getMethodName().length() == 1) {
            return;
        }
        if (this.getMethodName().equals(this.baseClassName)) {
            this.bugReporter.reportBug(new BugInstance("NM_CONFUSING_METHOD_NAME", 2).addClassAndMethod((PreorderVisitor)this));
        }
        if (obj.isPrivate() || obj.isStatic()) {
            return;
        }
        String trueName = new StringBuffer().append(this.getMethodName()).append(this.getMethodSig()).toString();
        String allSmall = new StringBuffer().append(this.getMethodName().toLowerCase()).append(this.getMethodSig()).toString();
        MyMethod mm = new MyMethod(this.getThisClass(), this.getMethodName(), this.getMethodSig());
        HashSet<Object> s = this.canonicalToTrueMapping.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToTrueMapping.put(allSmall, s);
        }
        s.add(trueName);
        s = this.canonicalToMyMethod.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToMyMethod.put(allSmall, s);
        }
        s.add((String)((Object)mm));
        if (this.getMethodName().equals("equal") && this.getMethodSig().equals("(Ljava/lang/Object;)Z")) {
            this.bugReporter.reportBug(new BugInstance("NM_BAD_EQUAL", 1).addClassAndMethod((PreorderVisitor)this));
        }
        if (this.getMethodName().equals("hashcode") && this.getMethodSig().equals("()I")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_HASHCODE", 1).addClassAndMethod((PreorderVisitor)this));
        }
        if (this.getMethodName().equals("tostring") && this.getMethodSig().equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_TOSTRING", 1).addClassAndMethod((PreorderVisitor)this));
        }
    }

    static class MyMethod {
        final JavaClass clazz;
        final String methodName;
        final String methodSig;

        MyMethod(JavaClass c, String n, String s) {
            this.clazz = c;
            this.methodName = n;
            this.methodSig = s;
        }

        public String getClassName() {
            return this.clazz.getClassName();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyMethod)) {
                return false;
            }
            MyMethod m2 = (MyMethod)o;
            return this.clazz.equals((Object)m2.clazz) && this.methodName.equals(m2.methodName) && this.methodSig.equals(m2.methodSig);
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.methodName.hashCode() + this.methodSig.hashCode();
        }

        public boolean confusingMethodNames(MyMethod m) {
            return this.methodName.equalsIgnoreCase(m.methodName) && !this.methodName.equals(m.methodName);
        }

        public String toString() {
            return this.getClassName() + "." + this.methodName + ":" + this.methodSig;
        }
    }
}

