/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;

public class FindTwoLockWait
implements Detector {
    private BugReporter bugReporter;
    private JavaClass javaClass;

    public FindTwoLockWait(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.javaClass = classContext.getJavaClass();
        Method[] methodList = this.javaClass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.preScreen(methodGen)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError(e.toString());
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError(e.toString());
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        LockDataflow dataflow = classContext.getLockDataflow(method);
        Iterator j = cfg.locationIterator();
        while (j.hasNext()) {
            Location location = (Location)j.next();
            this.visitInstruction(location, methodGen, dataflow);
        }
    }

    public boolean preScreen(MethodGen mg) {
        ConstantPoolGen cpg = mg.getConstantPool();
        int lockCount = mg.isSynchronized() ? 1 : 0;
        boolean sawWait = false;
        for (InstructionHandle handle = mg.getInstructionList().getStart(); !(handle == null || lockCount >= 2 && sawWait); handle = handle.getNext()) {
            INVOKEVIRTUAL inv;
            Instruction ins = handle.getInstruction();
            if (ins instanceof MONITORENTER) {
                ++lockCount;
                continue;
            }
            if (!(ins instanceof INVOKEVIRTUAL) || !(inv = (INVOKEVIRTUAL)ins).getMethodName(cpg).equals("wait")) continue;
            sawWait = true;
        }
        return lockCount >= 2 && sawWait;
    }

    public void visitInstruction(Location location, MethodGen methodGen, LockDataflow dataflow) {
        try {
            int count;
            ConstantPoolGen cpg = methodGen.getConstantPool();
            if (this.isWait(location.getHandle(), cpg) && (count = dataflow.getFactAtLocation(location).getNumLockedObjects()) > 1) {
                String sourceFile = this.javaClass.getSourceFileName();
                this.bugReporter.reportBug(new BugInstance("2LW_TWO_LOCK_WAIT", 2).addClass(this.javaClass).addMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()));
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException(e.getMessage());
        }
    }

    private boolean isWait(InstructionHandle handle, ConstantPoolGen cpg) {
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof INVOKEVIRTUAL)) {
            return false;
        }
        INVOKEVIRTUAL inv = (INVOKEVIRTUAL)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return methodName.equals("wait") && (methodSig.equals("()V") || methodSig.equals("(J)V") || methodSig.equals("(JI)V"));
    }

    public void report() {
    }
}

