/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;

public class DumbMethods
extends BytecodeScanningDetector
implements Constants2 {
    private HashSet<String> alreadyReported = new HashSet();
    private BugReporter bugReporter;
    private boolean sawCurrentTimeMillis;
    private BugInstance gcInvocationBugReport;
    private int gcInvocationPC;
    private CodeException[] exceptionTable;
    private boolean isPublicStaticVoidMain;
    private static final int OOM_CATCH_LEN = 20;

    public DumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method method) {
        this.flush();
        String cName = this.getDottedClassName();
        this.isPublicStaticVoidMain = method.isPublic() && method.isStatic() && this.getMethodName().equals("main") || cName.toLowerCase().indexOf("benchmark") >= 0;
        Code code = method.getCode();
        if (code != null) {
            this.exceptionTable = code.getExceptionTable();
        }
        if (this.exceptionTable == null) {
            this.exceptionTable = new CodeException[0];
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("(Ljava/lang/String;)V") && this.alreadyReported.add(this.getRefConstantOperand())) {
            this.bugReporter.reportBug(new BugInstance("DM_STRING_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 183 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V") && this.alreadyReported.add(this.getRefConstantOperand())) {
            this.bugReporter.reportBug(new BugInstance("DM_STRING_VOID_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if ((seen == 184 && this.getClassConstantOperand().equals("java/lang/System") || seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime")) && this.getNameConstantOperand().equals("gc") && this.getSigConstantOperand().equals("()V") && !this.getDottedClassName().startsWith("java.lang") && this.alreadyReported.add(this.getRefConstantOperand())) {
            if (this.isPublicStaticVoidMain) {
                return;
            }
            this.gcInvocationBugReport = new BugInstance("DM_GC", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this);
            this.gcInvocationPC = this.getPC();
        }
        if (seen == 183 && this.getClassConstantOperand().equals("java/lang/Boolean") && this.getNameConstantOperand().equals("<init>") && !this.getClassName().equals("java/lang/Boolean") && this.alreadyReported.add(this.getRefConstantOperand())) {
            this.bugReporter.reportBug(new BugInstance("DM_BOOLEAN_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 184 && this.getClassConstantOperand().equals("java/lang/System") && this.getNameConstantOperand().equals("currentTimeMillis")) {
            this.sawCurrentTimeMillis = true;
        }
    }

    public void report() {
        this.flush();
    }

    private void flush() {
        if (this.gcInvocationBugReport != null && !this.sawCurrentTimeMillis) {
            boolean outOfMemoryHandler = false;
            for (int i = 0; i < this.exceptionTable.length; ++i) {
                String exClassName;
                ConstantPool cp;
                Constant constant;
                int catchTypeIndex;
                CodeException handler = this.exceptionTable[i];
                if (this.gcInvocationPC < handler.getHandlerPC() || this.gcInvocationPC > handler.getHandlerPC() + 20 || (catchTypeIndex = handler.getCatchType()) <= 0 || !((constant = (cp = this.getThisClass().getConstantPool()).getConstant(catchTypeIndex)) instanceof ConstantClass) || !(exClassName = (String)((ConstantClass)constant).getConstantValue(cp)).equals("java/lang/OutOfMemoryError")) continue;
                outOfMemoryHandler = true;
                break;
            }
            if (!outOfMemoryHandler) {
                this.bugReporter.reportBug(this.gcInvocationBugReport);
            }
        }
        this.sawCurrentTimeMillis = false;
        this.gcInvocationBugReport = null;
        this.alreadyReported.clear();
        this.exceptionTable = null;
    }
}

