/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class StartInConstructor
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    boolean isFinal;

    public StartInConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.isFinal = (obj.getAccessFlags() & 0x10) != 0 || (obj.getAccessFlags() & 1) == 0;
    }

    public void visit(Code obj) {
        if (this.methodName.equals("<init>")) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (!this.isFinal && seen == 182 && this.nameConstant.equals("start") && this.sigConstant.equals("()V")) {
            try {
                if (Hierarchy.isSubtype((String)this.betterClassConstant, (String)"java.lang.Thread")) {
                    this.bugReporter.reportBug(new BugInstance("SC_START_IN_CTOR", 2).addClassAndMethod((BetterVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((DismantleBytecode)this));
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

