/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.classfile.Code;

public class PreferZeroLengthArrays
extends BytecodeScanningDetector
implements Constants2 {
    boolean nullOnTOS = false;
    private BugReporter bugReporter;

    public PreferZeroLengthArrays(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        String returnType = this.methodSig.substring(this.methodSig.indexOf(")") + 1);
        if (returnType.startsWith("[")) {
            this.nullOnTOS = false;
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 1: {
                this.nullOnTOS = true;
                return;
            }
            case 176: {
                if (!this.nullOnTOS) break;
                this.bugReporter.reportBug(new BugInstance("PZLA_PREFER_ZERO_LENGTH_ARRAYS", 3).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.PC));
            }
        }
        this.nullOnTOS = false;
    }
}

