/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindUnsyncGet
extends BytecodeScanningDetector
implements Constants2 {
    String prevClassName = " none ";
    private BugReporter bugReporter;
    static final int doNotConsider = 266;
    private HashMap<String, MethodAnnotation> getMethods = new HashMap();
    private HashMap<String, MethodAnnotation> setMethods = new HashMap();

    public FindUnsyncGet(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void report() {
        HashSet<String> commonProperties = new HashSet<String>(this.getMethods.keySet());
        commonProperties.retainAll(this.setMethods.keySet());
        Iterator<String> i = commonProperties.iterator();
        while (i.hasNext()) {
            String propName = i.next();
            MethodAnnotation getMethod = this.getMethods.get(propName);
            MethodAnnotation setMethod = this.setMethods.get(propName);
            this.bugReporter.reportBug(new BugInstance("UG_SYNC_SET_UNSYNC_GET", 2).addClass(this.prevClassName).addMethod(getMethod).addMethod(setMethod));
        }
        this.getMethods.clear();
        this.setMethods.clear();
    }

    public void visit(JavaClass obj) {
        this.report();
        this.prevClassName = this.betterClassName;
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int flags = obj.getAccessFlags();
        if ((flags & 0x10A) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        char firstArg = sig.charAt(1);
        char returnValue = sig.charAt(1 + sig.indexOf(41));
        boolean firstArgIsRef = firstArg == 'L' || firstArg == '[';
        boolean returnValueIsRef = returnValue == 'L' || returnValue == '[';
        boolean bl = isSynchronized = (flags & 0x20) != 0;
        if (name.startsWith("get") && !isSynchronized) {
            this.getMethods.put(name.substring(3), MethodAnnotation.fromVisitedMethod((BetterVisitor)this));
        } else if (name.startsWith("set") && isSynchronized) {
            this.setMethods.put(name.substring(3), MethodAnnotation.fromVisitedMethod((BetterVisitor)this));
        }
    }
}

