/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ExtendedTypes;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LocationScanner;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.StandardTypeMerger;
import edu.umd.cs.findbugs.ba.TypeAnalysis;
import edu.umd.cs.findbugs.ba.TypeDataflow;
import edu.umd.cs.findbugs.ba.TypeFrame;
import edu.umd.cs.findbugs.ba.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.TypeMerger;
import java.util.BitSet;
import java.util.HashSet;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindRefComparison
implements Detector,
ExtendedTypes {
    private static final boolean DEBUG = Boolean.getBoolean("frc.debug");
    private static final HashSet<String> suspiciousSet = new HashSet();
    private static final byte T_DYNAMIC_STRING = 22;
    private static final byte T_STATIC_STRING = 23;
    private static final String STRING_SIGNATURE = "Ljava/lang/String;";
    private static final Type dynamicStringTypeInstance;
    private static final Type staticStringTypeInstance;
    private BugReporter bugReporter;
    private BugInstance stringComparison;

    public FindRefComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            final JavaClass jclass = classContext.getJavaClass();
            Method[] methodList = jclass.getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                BitSet bytecodeSet;
                Method method = methodList[i];
                final MethodGen methodGen = classContext.getMethodGen(method);
                if (methodGen == null || !(bytecodeSet = classContext.getBytecodeSet(method)).get(165) && !bytecodeSet.get(166)) continue;
                if (DEBUG) {
                    System.out.println("FindRefComparison: analyzing " + SignatureConverter.convertMethodSignature((MethodGen)methodGen));
                }
                this.stringComparison = null;
                CFG cfg = classContext.getCFG(method);
                DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger((RepositoryLookupFailureCallback)this.bugReporter);
                RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), (RepositoryLookupFailureCallback)this.bugReporter);
                TypeAnalysis typeAnalysis = new TypeAnalysis(methodGen, dfs, (TypeMerger)typeMerger, (TypeFrameModelingVisitor)visitor);
                final TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
                typeDataflow.execute();
                new LocationScanner(cfg).scan(new LocationScanner.Callback(){

                    public void visitLocation(Location location) {
                        try {
                            InstructionHandle handle = location.getHandle();
                            Instruction ins = handle.getInstruction();
                            short opcode = ins.getOpcode();
                            if (opcode == 165 || opcode == 166) {
                                TypeFrame frame = typeDataflow.getFactAtLocation(location);
                                if (frame.getStackDepth() < 2) {
                                    throw new AnalysisException("Stack underflow", methodGen, handle);
                                }
                                int numSlots = frame.getNumSlots();
                                Type lhsType = (Type)frame.getValue(numSlots - 1);
                                Type rhsType = (Type)frame.getValue(numSlots - 2);
                                if (lhsType instanceof ReferenceType && rhsType instanceof ReferenceType) {
                                    String rhs;
                                    String lhs = SignatureConverter.convert((String)lhsType.getSignature());
                                    if (!lhs.equals(rhs = SignatureConverter.convert((String)rhsType.getSignature()))) {
                                        return;
                                    }
                                    if (lhs.equals("java.lang.String") && rhs.equals("java.lang.String")) {
                                        int priority = 3;
                                        byte type1 = lhsType.getType();
                                        byte type2 = rhsType.getType();
                                        if (type1 == 23 && type2 == 23) {
                                            priority = 4;
                                        } else if (type1 == 22 || type2 == 22) {
                                            priority = 1;
                                        } else if (type1 == 23 || type2 == 23) {
                                            priority = 2;
                                        }
                                        if (priority <= 3) {
                                            String sourceFile = jclass.getSourceFileName();
                                            BugInstance instance = new BugInstance("ES_COMPARING_STRINGS_WITH_EQ", priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle).addClass("java.lang.String").describe("CLASS_REFTYPE");
                                            if (FindRefComparison.this.stringComparison == null || priority < FindRefComparison.this.stringComparison.getPriority()) {
                                                FindRefComparison.this.stringComparison = instance;
                                            }
                                        }
                                    } else if (suspiciousSet.contains(lhs) && suspiciousSet.contains(rhs)) {
                                        String sourceFile = jclass.getSourceFileName();
                                        FindRefComparison.this.bugReporter.reportBug(new BugInstance("RC_REF_COMPARISON", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle).addClass(lhs).describe("CLASS_REFTYPE"));
                                    }
                                }
                            }
                        }
                        catch (DataflowAnalysisException e) {
                            throw new AnalysisException(new StringBuffer().append("Caught exception: ").append(e.toString()).toString(), (Throwable)e);
                        }
                    }
                });
                if (this.stringComparison == null) continue;
                this.bugReporter.reportBug(this.stringComparison);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("Exception in FindRefComparison: " + e.getMessage(), (Throwable)e);
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("Exception in FindRefComparison: " + e.getMessage(), (Throwable)e);
        }
    }

    public void report() {
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("Usage: " + FindRefComparison.class.getName() + " <class file>");
            System.exit(1);
        }
        DataflowTestDriver<TypeFrame, TypeAnalysis> driver = new DataflowTestDriver<TypeFrame, TypeAnalysis>(){

            public Dataflow<TypeFrame, TypeAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                RepositoryLookupFailureCallback lookupFailureCallback = classContext.getLookupFailureCallback();
                MethodGen methodGen = classContext.getMethodGen(method);
                DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                CFG cfg = classContext.getCFG(method);
                RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger(lookupFailureCallback);
                RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), lookupFailureCallback);
                TypeAnalysis analysis = new TypeAnalysis(methodGen, dfs, (TypeMerger)typeMerger, (TypeFrameModelingVisitor)visitor);
                Dataflow dataflow = new Dataflow(cfg, (DataflowAnalysis)analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(argv[0]);
    }

    static {
        suspiciousSet.add("java.lang.Boolean");
        suspiciousSet.add("java.lang.Byte");
        suspiciousSet.add("java.lang.Character");
        suspiciousSet.add("java.lang.Double");
        suspiciousSet.add("java.lang.Float");
        suspiciousSet.add("java.lang.Integer");
        suspiciousSet.add("java.lang.Long");
        suspiciousSet.add("java.lang.Short");
        dynamicStringTypeInstance = new DynamicStringType();
        staticStringTypeInstance = new StaticStringType();
    }

    private static class RefComparisonTypeMerger
    extends StandardTypeMerger {
        public RefComparisonTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback) {
            super(lookupFailureCallback);
        }

        protected boolean isReferenceType(byte type) {
            return super.isReferenceType(type) || type == 23 || type == 22;
        }

        protected Type mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
            byte aType = aRef.getType();
            byte bType = bRef.getType();
            if (this.isExtendedStringType(aType) || this.isExtendedStringType(bType)) {
                if (aType == bType) {
                    return aRef;
                }
                if (this.isExtendedStringType(aType)) {
                    aRef = Type.STRING;
                }
                if (this.isExtendedStringType(bType)) {
                    bRef = Type.STRING;
                }
            }
            return super.mergeReferenceTypes(aRef, bRef);
        }

        private boolean isExtendedStringType(byte type) {
            return type == 22 || type == 23;
        }
    }

    private static class RefComparisonTypeFrameModelingVisitor
    extends TypeFrameModelingVisitor {
        private RepositoryLookupFailureCallback lookupFailureCallback;

        public RefComparisonTypeFrameModelingVisitor(ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
            super(cpg);
            this.lookupFailureCallback = lookupFailureCallback;
        }

        public void visitINVOKESTATIC(INVOKESTATIC obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString((InvokeInstruction)obj)) {
                String className = obj.getClassName(this.getCPG());
                String methodName = obj.getName(this.getCPG());
                if (className.equals("java.lang.String") && methodName.equals("valueOf")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType((InvokeInstruction)obj);
                }
            } else {
                this.pushReturnType((InvokeInstruction)obj);
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        private boolean returnsString(InvokeInstruction inv) {
            String methodSig = inv.getSignature(this.getCPG());
            return methodSig.endsWith(")Ljava/lang/String;");
        }

        private void handleInstanceMethod(InvokeInstruction obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString(obj)) {
                String className = obj.getClassName(this.getCPG());
                String methodName = obj.getName(this.getCPG());
                if (methodName.equals("toString")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else if (methodName.equals("intern") && className.equals("java.lang.String")) {
                    this.pushValue(staticStringTypeInstance);
                } else {
                    this.pushReturnType(obj);
                }
            } else {
                this.pushReturnType(obj);
            }
        }

        public void visitLDC(LDC obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        public void visitLDC2_W(LDC2_W obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        private boolean isString(Type type) {
            return type.getSignature().equals(FindRefComparison.STRING_SIGNATURE);
        }

        public void visitGETSTATIC(GETSTATIC obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        public void visitGETFIELD(GETFIELD obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        private void handleLoad(FieldInstruction obj) {
            this.consumeStack((Instruction)obj);
            Type type = obj.getType(this.getCPG());
            if (type.getSignature().equals(FindRefComparison.STRING_SIGNATURE)) {
                try {
                    String className = obj.getClassName(this.getCPG());
                    String fieldName = obj.getName(this.getCPG());
                    Field field = Hierarchy.findField((String)className, (String)fieldName);
                    if (field != null) {
                        if (field.isFinal()) {
                            this.pushValue(staticStringTypeInstance);
                        } else {
                            this.pushValue(type);
                        }
                        return;
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.lookupFailureCallback.reportMissingClass(ex);
                }
            }
            this.pushValue(type);
        }
    }

    private static class StaticStringType
    extends ReferenceType {
        public StaticStringType() {
            super((byte)23, FindRefComparison.STRING_SIGNATURE);
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<static string>";
        }
    }

    private static class DynamicStringType
    extends ReferenceType {
        public DynamicStringType() {
            super((byte)22, FindRefComparison.STRING_SIGNATURE);
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<dynamic string>";
        }
    }
}

