/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LocationScanner;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.ValueNumber;
import edu.umd.cs.findbugs.ba.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.ValueNumberFrame;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class FindMismatchedWaitOrNotify
implements Detector {
    private BugReporter bugReporter;

    public FindMismatchedWaitOrNotify(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        Method[] methodList = jclass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            BitSet bytecodeSet;
            Method method = methodList[i];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !(bytecodeSet = classContext.getBytecodeSet(method)).get(194) || !bytecodeSet.get(182)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                throw new AnalysisException("FindMismatchedWaitOrNotify: caught exception " + e.toString(), (Throwable)e);
            }
            catch (CFGBuilderException e) {
                throw new AnalysisException("FindMismatchedWaitOrNotify: caught exception " + e.toString(), (Throwable)e);
            }
        }
    }

    private void analyzeMethod(final ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        final MethodGen methodGen = classContext.getMethodGen(method);
        final ConstantPoolGen cpg = methodGen.getConstantPool();
        CFG cfg = classContext.getCFG(method);
        final ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        final LockDataflow dataflow = classContext.getLockDataflow(method);
        new LocationScanner(cfg).scan(new LocationScanner.Callback(){

            public void visitLocation(Location location) {
                try {
                    String methodSig;
                    BasicBlock basicBlock = location.getBasicBlock();
                    InstructionHandle handle = location.getHandle();
                    Instruction ins = handle.getInstruction();
                    if (!(ins instanceof INVOKEVIRTUAL)) {
                        return;
                    }
                    INVOKEVIRTUAL inv = (INVOKEVIRTUAL)ins;
                    String methodName = inv.getName(cpg);
                    if (Hierarchy.isMonitorWait((String)methodName, (String)(methodSig = inv.getSignature(cpg))) || Hierarchy.isMonitorNotify((String)methodName, (String)methodSig)) {
                        int numConsumed = inv.consumeStack(cpg);
                        if (numConsumed == -2) {
                            throw new AnalysisException("Unpredictable stack consumption", methodGen, handle);
                        }
                        ValueNumberFrame frame = vnaDataflow.getFactAtLocation(location);
                        if (frame.getStackDepth() - numConsumed < 0) {
                            throw new AnalysisException("Stack underflow", methodGen, handle);
                        }
                        ValueNumber ref = (ValueNumber)frame.getValue(frame.getNumSlots() - numConsumed);
                        LockSet lockSet = dataflow.getFactAtLocation(location);
                        int lockCount = lockSet.getLockCount(ref.getNumber());
                        if (lockCount == 0) {
                            String sourceFile = classContext.getJavaClass().getSourceFileName();
                            String type = methodName.equals("wait") ? "MWN_MISMATCHED_WAIT" : "MWN_MISMATCHED_NOTIFY";
                            FindMismatchedWaitOrNotify.this.bugReporter.reportBug(new BugInstance(type, 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle));
                        }
                    }
                }
                catch (DataflowAnalysisException e) {
                    throw new AnalysisException(new StringBuffer().append("FindMismatchedWaitOrNotify: caught exception ").append(e.toString()).toString(), (Throwable)e);
                }
            }
        });
    }

    public void report() {
    }
}

