/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.Invoke;
import edu.umd.cs.findbugs.ba.bcp.MatchAny;
import edu.umd.cs.findbugs.ba.bcp.Opcode;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class BCPMethodReturnCheck
extends ByteCodePatternDetector {
    private final BugReporter bugReporter;
    private final ByteCodePattern pattern;
    private static final boolean CHECK_ALL = Boolean.getBoolean("mrc.checkall");

    private static PatternElement[] createPatternElementList(BugReporter bugReporter) {
        ArrayList<Invoke> list = new ArrayList<Invoke>();
        list.add(new Invoke("java.lang.String", "/.*", "/\\(.*\\)Ljava/lang/String;", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("java.lang.StringBuffer", "toString", "()Ljava/lang/String;", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("+java.lang.Thread", "<init>", "/.*", 4, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("java.security.MessageDigest", "digest", "([B)[B", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("+java.net.InetAddress", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("java.math.BigDecimal", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("java.math.BigInteger", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter));
        list.add(new Invoke("java.io.File", "createNewFile", "()Z", 1, (RepositoryLookupFailureCallback)bugReporter));
        String version = System.getProperty("java.version");
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\..*$");
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                if (CHECK_ALL || major > 1 || minor >= 5) {
                    list.add(new Invoke("+java.util.concurrent.locks.ReadWriteLock", "readLock", "()Ljava/util/concurrent/Lock;", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.ReadWriteLock", "writeLock", "()Ljava/util/concurrent/Lock;", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.Condition", "await", "(JLjava/util/concurrent/TimeUnit;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.Condition", "awaitUtil", "(Ljava/util/Date;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.Condition", "awaitNanos", "(J)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.Semaphore", "tryAcquire", "(JLjava/util/concurrent/TimeUnit;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.Semaphore", "tryAcquire", "()Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.Lock", "tryLock", "(JLjava/util/concurrent/TimeUnit;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.locks.Lock", "tryLock", "()Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.Queue", "offer", "(Ljava/lang/Object;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.BlockingQueue", "offer", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.concurrent.BlockingQueue", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", 1, (RepositoryLookupFailureCallback)bugReporter));
                    list.add(new Invoke("+java.util.Queue", "poll", "()Ljava/lang/Object;", 1, (RepositoryLookupFailureCallback)bugReporter));
                }
            }
            catch (NumberFormatException e) {
                bugReporter.logError("Bad java version: " + version);
            }
        }
        return list.toArray(new PatternElement[0]);
    }

    public BCPMethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.pattern = new ByteCodePattern().add(new MatchAny(BCPMethodReturnCheck.createPatternElementList(bugReporter)).label("call").setAllowTrailingEdges(false)).add((PatternElement)new MatchAny(new PatternElement[]{new Opcode(87), new Opcode(88)}));
    }

    public ByteCodePattern getPattern() {
        return this.pattern;
    }

    public boolean prescreen(Method method, ClassContext classContext) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(87) || bytecodeSet.get(88);
    }

    public void reportMatch(ClassContext classContext, Method method, ByteCodePatternMatch match) {
        MethodGen methodGen = classContext.getMethodGen(method);
        JavaClass javaClass = classContext.getJavaClass();
        InstructionHandle call = match.getLabeledInstruction("call");
        InvokeInstruction inv = (InvokeInstruction)call.getInstruction();
        String calledMethodName = inv.getMethodName(methodGen.getConstantPool());
        if (calledMethodName.startsWith("access$") || calledMethodName.startsWith("access+")) {
            return;
        }
        String sourceFile = javaClass.getSourceFileName();
        this.bugReporter.reportBug(new BugInstance("RV_RETURN_VALUE_IGNORED", calledMethodName.equals("createNewFile") ? 3 : 2).addClassAndMethod(methodGen, sourceFile).addCalledMethod(methodGen, inv).addSourceLine(methodGen, sourceFile, call));
    }
}

