/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysisTestDriver;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.Stream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOpenStream
extends ResourceTrackingDetector<Stream, StreamResourceTracker> {
    private static final boolean DEBUG = Boolean.getBoolean("fos.debug");
    private static final boolean IGNORE_WRAPPED_UNINTERESTING_STREAMS = !Boolean.getBoolean("fos.allowWUS");
    private List<PotentialOpenStream> potentialOpenStreamList = new LinkedList<PotentialOpenStream>();
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindOpenStream;

    public FindOpenStream(BugReporter bugReporter) {
        super(bugReporter);
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(187);
    }

    public StreamResourceTracker getResourceTracker(ClassContext classContext, Method method) {
        return new StreamResourceTracker((RepositoryLookupFailureCallback)this.bugReporter);
    }

    public static boolean isMainMethod(Method method) {
        return method.isStatic() && method.getName().equals("main") && method.getSignature().equals("([Ljava/lang/String;)V");
    }

    public void analyzeMethod(ClassContext classContext, Method method, StreamResourceTracker resourceTracker) throws CFGBuilderException, DataflowAnalysisException {
        if (FindOpenStream.isMainMethod(method)) {
            return;
        }
        this.potentialOpenStreamList.clear();
        super.analyzeMethod(classContext, method, (ResourceTracker)resourceTracker);
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        resourceTracker.markTransitiveUninterestingStreamEscapes();
        for (PotentialOpenStream pos : this.potentialOpenStreamList) {
            InstructionHandle constructionHandle;
            Stream stream = pos.stream;
            if (stream.isUninteresting() || (constructionHandle = stream.getConstructorHandle()) == null || IGNORE_WRAPPED_UNINTERESTING_STREAMS && resourceTracker.isUninterestingStreamEscape(constructionHandle)) continue;
            String sourceFile = javaClass.getSourceFileName();
            this.bugReporter.reportBug(new BugInstance(pos.bugType, pos.priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, stream.getLocation().getHandle()));
        }
    }

    public void inspectResult(JavaClass javaClass, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>> dataflow, Stream stream) {
        ResourceValueFrame exitFrame = (ResourceValueFrame)dataflow.getResultFact(cfg.getExit());
        int exitStatus = exitFrame.getStatus();
        if (exitStatus == 1 || exitStatus == 2) {
            int priority;
            String bugType;
            if (exitStatus == 1) {
                bugType = "OS_OPEN_STREAM";
                priority = 2;
            } else {
                bugType = "OS_OPEN_STREAM_EXCEPTION_PATH";
                priority = 3;
            }
            this.potentialOpenStreamList.add(new PotentialOpenStream(bugType, priority, stream));
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$detect$FindOpenStream == null ? (class$edu$umd$cs$findbugs$detect$FindOpenStream = FindOpenStream.class$("edu.umd.cs.findbugs.detect.FindOpenStream")) : class$edu$umd$cs$findbugs$detect$FindOpenStream).getName()).append(" <class file> <method name> <bytecode offset>").toString());
            System.exit(1);
        }
        String classFile = argv[0];
        String methodName = argv[1];
        int offset = Integer.parseInt(argv[2]);
        ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker> driver = new ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker>(){

            public StreamResourceTracker createResourceTracker(ClassContext classContext, Method method) {
                return new StreamResourceTracker(classContext.getLookupFailureCallback());
            }

            public /* synthetic */ ResourceTracker createResourceTracker(ClassContext x0, Method x1) throws CFGBuilderException, DataflowAnalysisException {
                return this.createResourceTracker(x0, x1);
            }
        };
        driver.execute(classFile, methodName, offset);
    }

    public /* synthetic */ void analyzeMethod(ClassContext x0, Method x1, ResourceTracker x2) throws CFGBuilderException, DataflowAnalysisException {
        this.analyzeMethod(x0, x1, (StreamResourceTracker)x2);
    }

    public /* synthetic */ void inspectResult(JavaClass x0, MethodGen x1, CFG x2, Dataflow x3, Object x4) {
        this.inspectResult(x0, x1, x2, (Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>>)x3, (Stream)((Object)x4));
    }

    public /* synthetic */ ResourceTracker getResourceTracker(ClassContext x0, Method x1) throws DataflowAnalysisException, CFGBuilderException {
        return this.getResourceTracker(x0, x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private static class PotentialOpenStream {
        public final String bugType;
        public final int priority;
        public final Stream stream;

        public PotentialOpenStream(String bugType, int priority, Stream stream) {
            this.bugType = bugType;
            this.priority = priority;
            this.stream = stream;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StreamResourceTracker
    implements ResourceTracker<Stream> {
        private RepositoryLookupFailureCallback lookupFailureCallback;
        private BitSet streamConstructionSet;
        private BitSet uninterestingStreamEscapeSet;
        private TreeSet<StreamEscape> streamEscapeSet;

        public StreamResourceTracker(RepositoryLookupFailureCallback lookupFailureCallback) {
            this.lookupFailureCallback = lookupFailureCallback;
            this.streamConstructionSet = new BitSet();
            this.uninterestingStreamEscapeSet = new BitSet();
            this.streamEscapeSet = new TreeSet();
        }

        public void addStreamEscape(InstructionHandle source, InstructionHandle target) {
            StreamEscape streamEscape = new StreamEscape(source, target);
            this.streamEscapeSet.add(streamEscape);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Adding potential stream escape ").append(streamEscape).toString());
            }
        }

        public void markTransitiveUninterestingStreamEscapes() {
            Iterator<StreamEscape> i = this.streamEscapeSet.iterator();
            while (i.hasNext()) {
                StreamEscape streamEscape = i.next();
                if (this.isStreamConstruction(streamEscape.target)) continue;
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Eliminating false stream escape ").append(streamEscape).toString());
                }
                i.remove();
            }
            BitSet orig = new BitSet();
            do {
                orig.clear();
                orig.or(this.uninterestingStreamEscapeSet);
                for (StreamEscape streamEscape : this.streamEscapeSet) {
                    if (!this.isUninterestingStreamEscape(streamEscape.source)) continue;
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Propagating stream escape ").append(streamEscape).toString());
                    }
                    this.uninterestingStreamEscapeSet.set(streamEscape.target.getPosition());
                }
            } while (!orig.equals(this.uninterestingStreamEscapeSet));
        }

        public boolean isUninterestingStreamEscape(InstructionHandle handle) {
            return this.uninterestingStreamEscapeSet.get(handle.getPosition());
        }

        public void addStreamConstruction(InstructionHandle streamConstruction, boolean isUninteresting) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Stream construction at ").append(streamConstruction.getPosition()).toString());
            }
            this.streamConstructionSet.set(streamConstruction.getPosition());
            if (isUninteresting) {
                this.uninterestingStreamEscapeSet.set(streamConstruction.getPosition());
            }
        }

        private boolean isStreamConstruction(InstructionHandle handle) {
            return this.streamConstructionSet.get(handle.getPosition());
        }

        public Stream isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) {
            Instruction ins = handle.getInstruction();
            Location location = new Location(handle, basicBlock);
            try {
                GETSTATIC getstatic;
                String className;
                if (ins instanceof NEW) {
                    NEW newIns = (NEW)ins;
                    Type type = newIns.getType(cpg);
                    String sig = type.getSignature();
                    if (!sig.startsWith("L") || !sig.endsWith(";")) {
                        return null;
                    }
                    String className2 = sig.substring(1, sig.length() - 1).replace('/', '.');
                    if (Repository.instanceOf((String)className2, (String)"java.io.InputStream")) {
                        boolean isUninteresting = Repository.instanceOf((String)className2, (String)"java.io.ByteArrayInputStream") || Repository.instanceOf((String)className2, (String)"java.io.ObjectInputStream");
                        return new Stream(location, className2, "java.io.InputStream", isUninteresting);
                    }
                    if (Repository.instanceOf((String)className2, (String)"java.io.OutputStream")) {
                        boolean isUninteresting = Repository.instanceOf((String)className2, (String)"java.io.ByteArrayOutputStream") || Repository.instanceOf((String)className2, (String)"java.io.ObjectOutputStream");
                        return new Stream(location, className2, "java.io.OutputStream", isUninteresting);
                    }
                    if (Repository.instanceOf((String)className2, (String)"java.io.Reader")) {
                        boolean isUninteresting = Repository.instanceOf((String)className2, (String)"java.io.StringReader") || Repository.instanceOf((String)className2, (String)"java.io.CharArrayReader");
                        return new Stream(location, className2, "java.io.Reader", isUninteresting);
                    }
                    if (Repository.instanceOf((String)className2, (String)"java.io.Writer")) {
                        boolean isUninteresting = Repository.instanceOf((String)className2, (String)"java.io.StringWriter") || Repository.instanceOf((String)className2, (String)"java.io.CharArrayWriter");
                        return new Stream(location, className2, "java.io.Writer", isUninteresting);
                    }
                } else if (ins instanceof INVOKEVIRTUAL) {
                    INVOKEVIRTUAL inv = (INVOKEVIRTUAL)ins;
                    String className3 = inv.getClassName(cpg);
                    if (Repository.instanceOf((String)className3, (String)"java.net.Socket")) {
                        String methodName = inv.getName(cpg);
                        String methodSig = inv.getSignature(cpg);
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("Socket call: ").append(methodName).append(" : ").append(methodSig).toString());
                        }
                        if (methodName.equals("getOutputStream") && methodSig.endsWith(")Ljava/io/OutputStream;")) {
                            return new Stream(location, "java.io.OutputStream", "java.io.OutputStream", true, true);
                        }
                        if (methodName.equals("getInputStream") && methodSig.endsWith(")Ljava/io/InputStream;")) {
                            return new Stream(location, "java.io.InputStream", "java.io.InputStream", true, true);
                        }
                    }
                } else if (ins instanceof GETSTATIC && (className = (getstatic = (GETSTATIC)ins).getClassName(cpg)).equals("java.lang.System")) {
                    String fieldName = getstatic.getName(cpg);
                    String fieldSig = getstatic.getSignature(cpg);
                    if (fieldName.equals("in") && fieldSig.equals("Ljava/io/InputStream;")) {
                        return new Stream(location, "java.io.InputStream", "java.io.InputStream", true, true);
                    }
                    if ((fieldName.equals("out") || fieldName.equals("err")) && fieldSig.equals("Ljava/io/PrintStream;")) {
                        return new Stream(location, "java.io.PrintStream", "java.io.OutputStream", true, true);
                    }
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
                return null;
            }
        }

        public boolean isResourceOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
            Instruction ins = handle.getInstruction();
            if (ins instanceof INVOKESPECIAL) {
                INVOKESPECIAL inv = (INVOKESPECIAL)ins;
                if (frame.isValid() && this.getInstanceValue(frame, (InvokeInstruction)inv, cpg).isInstance() && this.matchMethod((InvokeInstruction)inv, cpg, resource.getResourceClass(), "<init>")) {
                    return true;
                }
            }
            return false;
        }

        public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
            Instruction ins = handle.getInstruction();
            if (ins instanceof INVOKEVIRTUAL) {
                INVOKEVIRTUAL inv = (INVOKEVIRTUAL)ins;
                if (!frame.isValid() || !this.getInstanceValue(frame, (InvokeInstruction)inv, cpg).isInstance()) {
                    return false;
                }
                try {
                    String streamBase = resource.getStreamBase();
                    return inv.getName(cpg).equals("close") && inv.getSignature(cpg).equals("()V") && Repository.instanceOf((String)inv.getClassName(cpg), (String)streamBase);
                }
                catch (ClassNotFoundException e) {
                    this.lookupFailureCallback.reportMissingClass(e);
                    return false;
                }
            }
            return false;
        }

        public ResourceValueFrameModelingVisitor createVisitor(Stream resource, ConstantPoolGen cpg) {
            return new StreamFrameModelingVisitor(cpg, this, resource);
        }

        private ResourceValue getInstanceValue(ResourceValueFrame frame, InvokeInstruction inv, ConstantPoolGen cpg) {
            int numConsumed = inv.consumeStack(cpg);
            if (numConsumed == -2) {
                throw new IllegalStateException();
            }
            return (ResourceValue)frame.getValue(frame.getNumSlots() - numConsumed);
        }

        private boolean matchMethod(InvokeInstruction inv, ConstantPoolGen cpg, String className, String methodName) {
            return inv.getClassName(cpg).equals(className) && inv.getName(cpg).equals(methodName);
        }

        private boolean matchMethod(InvokeInstruction inv, ConstantPoolGen cpg, String className, String methodName, String methodSig) {
            if (!this.matchMethod(inv, cpg, className, methodName)) {
                return false;
            }
            return inv.getSignature(cpg).equals(methodSig);
        }

        public /* synthetic */ ResourceValueFrameModelingVisitor createVisitor(Object x0, ConstantPoolGen x1) {
            return this.createVisitor((Stream)((Object)x0), x1);
        }

        public /* synthetic */ boolean isResourceClose(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2, Object x3, ResourceValueFrame x4) throws DataflowAnalysisException {
            return this.isResourceClose(x0, x1, x2, (Stream)((Object)x3), x4);
        }

        public /* synthetic */ Object isResourceCreation(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2) throws DataflowAnalysisException {
            return this.isResourceCreation(x0, x1, x2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StreamEscape
    implements Comparable<StreamEscape> {
        public final InstructionHandle source;
        public final InstructionHandle target;

        public StreamEscape(InstructionHandle source, InstructionHandle target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public int compareTo(StreamEscape other) {
            int cmp = this.source.getPosition() - other.source.getPosition();
            if (cmp != 0) {
                return cmp;
            }
            return this.target.getPosition() - other.target.getPosition();
        }

        public String toString() {
            return new StringBuffer().append(this.source.getPosition()).append(" to ").append(this.target.getPosition()).toString();
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((StreamEscape)x0);
        }
    }

    private static class StreamFrameModelingVisitor
    extends ResourceValueFrameModelingVisitor {
        private StreamResourceTracker resourceTracker;
        private Stream stream;
        private InstructionHandle handle;

        public StreamFrameModelingVisitor(ConstantPoolGen cpg, StreamResourceTracker resourceTracker, Stream stream) {
            super(cpg);
            this.resourceTracker = resourceTracker;
            this.stream = stream;
        }

        public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) {
            this.handle = handle;
            Instruction ins = handle.getInstruction();
            ConstantPoolGen cpg = this.getCPG();
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            int status = -1;
            boolean created = false;
            Location creationPoint = this.stream.getLocation();
            if (handle == creationPoint.getHandle() && basicBlock == creationPoint.getBasicBlock()) {
                if (this.stream.isOpenOnCreation()) {
                    status = 1;
                    this.stream.setConstructorHandle(handle);
                    this.resourceTracker.addStreamConstruction(handle, this.stream.isUninteresting());
                } else {
                    status = 4;
                }
                created = true;
            } else if (this.resourceTracker.isResourceOpen(basicBlock, handle, cpg, this.stream, frame)) {
                status = 1;
                this.stream.setConstructorHandle(handle);
                this.resourceTracker.addStreamConstruction(handle, this.stream.isUninteresting());
            } else if (this.resourceTracker.isResourceClose(basicBlock, handle, cpg, this.stream, frame)) {
                status = 3;
            }
            ins.accept((Visitor)this);
            if (status != -1) {
                frame.setStatus(status);
                if (created) {
                    frame.setValue(frame.getNumSlots() - 1, (Object)ResourceValue.instance());
                }
            }
        }

        protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
            boolean escapes;
            ConstantPoolGen cpg = this.getCPG();
            String className = inv.getClassName(cpg);
            boolean bl = escapes = inv.getOpcode() == 184 || instanceArgNum != 0;
            if (DEBUG && escapes) {
                System.out.println("ESCAPE at " + this.handle.getPosition());
            }
            if (this.stream.getConstructorHandle() != null) {
                this.resourceTracker.addStreamEscape(this.stream.getConstructorHandle(), this.handle);
            }
            return escapes;
        }
    }
}

