/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.IsNullValue;
import edu.umd.cs.findbugs.ba.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class FindNullDeref
implements Detector {
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug");
    private BugReporter bugReporter;
    private List<RedundantBranch> redundantBranchList;
    private BitSet definitelySameBranchSet;
    private BitSet definitelyDifferentBranchSet;
    private BitSet undeterminedBranchSet;

    public FindNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.redundantBranchList = new LinkedList<RedundantBranch>();
        this.definitelySameBranchSet = new BitSet();
        this.definitelyDifferentBranchSet = new BitSet();
        this.undeterminedBranchSet = new BitSet();
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass jclass = classContext.getJavaClass();
            Method[] methodList = jclass.getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                Method method = methodList[i];
                if (method.isAbstract() || method.isNative() || method.getCode() == null) continue;
                this.analyzeMethod(classContext, method);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("FindNullDeref caught exception: " + (Object)((Object)e), (Throwable)e);
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException(e.getMessage());
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        JavaClass jclass = classContext.getJavaClass();
        if (DEBUG) {
            System.out.println("Clearing redundant branch information");
        }
        this.redundantBranchList.clear();
        this.definitelySameBranchSet.clear();
        this.definitelyDifferentBranchSet.clear();
        this.undeterminedBranchSet.clear();
        if (DEBUG) {
            System.out.println(SignatureConverter.convertMethodSignature((MethodGen)classContext.getMethodGen(method)));
        }
        IsNullValueDataflow invDataflow = classContext.getIsNullValueDataflow(method);
        Iterator bbIter = invDataflow.getCFG().blockIterator();
        while (bbIter.hasNext()) {
            BasicBlock basicBlock = (BasicBlock)bbIter.next();
            if (basicBlock.isNullCheck()) {
                this.analyzeNullCheck(classContext, method, invDataflow, basicBlock);
                continue;
            }
            if (basicBlock.isEmpty()) continue;
            InstructionHandle lastHandle = basicBlock.getLastInstruction();
            Instruction last = lastHandle.getInstruction();
            switch (last.getOpcode()) {
                case 165: 
                case 166: {
                    this.analyzeRefComparisonBranch(method, invDataflow, basicBlock, lastHandle);
                    break;
                }
                case 198: 
                case 199: {
                    this.analyzeIfNullBranch(method, invDataflow, basicBlock, lastHandle);
                }
            }
        }
        Iterator<RedundantBranch> i = this.redundantBranchList.iterator();
        while (i.hasNext()) {
            RedundantBranch redundantBranch = i.next();
            if (DEBUG) {
                System.out.println("Redundant branch: " + redundantBranch);
            }
            InstructionHandle handle = redundantBranch.handle;
            int lineNumber = redundantBranch.lineNumber;
            if (this.undeterminedBranchSet.get(lineNumber) || this.definitelySameBranchSet.get(lineNumber) && this.definitelyDifferentBranchSet.get(lineNumber)) continue;
            this.reportUselessControlFlow(classContext, method, handle);
        }
    }

    private void analyzeNullCheck(ClassContext classContext, Method method, IsNullValueDataflow invDataflow, BasicBlock basicBlock) throws DataflowAnalysisException {
        InstructionHandle exceptionThrowerHandle = basicBlock.getExceptionThrower();
        Instruction exceptionThrower = exceptionThrowerHandle.getInstruction();
        int consumed = exceptionThrower.consumeStack(classContext.getConstantPoolGen());
        if (consumed == -2) {
            throw new DataflowAnalysisException("Unpredictable stack consumption for " + exceptionThrower);
        }
        IsNullValueFrame frame = (IsNullValueFrame)invDataflow.getStartFact(basicBlock);
        if (frame.isValid()) {
            IsNullValue refValue = (IsNullValue)frame.getValue(frame.getNumSlots() - consumed);
            boolean onExceptionPath = refValue.isException();
            if (refValue.isDefinitelyNull()) {
                String type = onExceptionPath ? "NP_ALWAYS_NULL_EXCEPTION" : "NP_ALWAYS_NULL";
                int priority = onExceptionPath ? 3 : 1;
                this.reportNullDeref(classContext, method, exceptionThrowerHandle, type, priority);
            } else if (refValue.isNullOnSomePath()) {
                int priority;
                String type = onExceptionPath ? "NP_NULL_ON_SOME_PATH_EXCEPTION" : "NP_NULL_ON_SOME_PATH";
                int n = priority = onExceptionPath ? 3 : 2;
                if (DEBUG) {
                    System.out.println("Reporting null on some path: value=" + refValue);
                }
                this.reportNullDeref(classContext, method, exceptionThrowerHandle, type, priority);
            }
        }
    }

    private void analyzeRefComparisonBranch(Method method, IsNullValueDataflow invDataflow, BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        boolean definitelyDifferent;
        IsNullValueFrame frame = invDataflow.getFactAtLocation(new Location(lastHandle, basicBlock));
        if (!frame.isValid()) {
            return;
        }
        if (frame.getStackDepth() < 2) {
            throw new AnalysisException("Stack underflow at " + lastHandle);
        }
        int lineNumber = FindNullDeref.getLineNumber(method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        int numSlots = frame.getNumSlots();
        IsNullValue top = (IsNullValue)frame.getValue(numSlots - 1);
        IsNullValue topNext = (IsNullValue)frame.getValue(numSlots - 2);
        boolean definitelySame = top.isDefinitelyNull() && topNext.isDefinitelyNull();
        boolean bl = definitelyDifferent = top.isDefinitelyNull() && topNext.isDefinitelyNotNull() || top.isDefinitelyNotNull() && topNext.isDefinitelyNull();
        if (definitelySame || definitelyDifferent) {
            if (definitelySame) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always same");
                }
                this.definitelySameBranchSet.set(lineNumber);
            }
            if (definitelyDifferent) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always different");
                }
                this.definitelyDifferentBranchSet.set(lineNumber);
            }
            RedundantBranch redundantBranch = new RedundantBranch(lastHandle, lineNumber);
            if (DEBUG) {
                System.out.println("Adding redundant branch: " + redundantBranch);
            }
            this.redundantBranchList.add(redundantBranch);
        } else {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " undetermined");
            }
            this.undeterminedBranchSet.set(lineNumber);
        }
    }

    private void analyzeIfNullBranch(Method method, IsNullValueDataflow invDataflow, BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        IsNullValueFrame frame = invDataflow.getFactAtLocation(new Location(lastHandle, basicBlock));
        if (!frame.isValid()) {
            return;
        }
        IsNullValue top = (IsNullValue)frame.getTopValue();
        int lineNumber = FindNullDeref.getLineNumber(method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        boolean definitelySame = top.isDefinitelyNull();
        boolean definitelyDifferent = top.isDefinitelyNotNull();
        if (definitelySame || definitelyDifferent) {
            if (definitelySame) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always same");
                }
                this.definitelySameBranchSet.set(lineNumber);
            }
            if (definitelyDifferent) {
                if (DEBUG) {
                    System.out.println("Line " + lineNumber + " always different");
                }
                this.definitelyDifferentBranchSet.set(lineNumber);
            }
            RedundantBranch redundantBranch = new RedundantBranch(lastHandle, lineNumber);
            if (DEBUG) {
                System.out.println("Adding redundant branch: " + redundantBranch);
            }
            this.redundantBranchList.add(redundantBranch);
        } else {
            if (DEBUG) {
                System.out.println("Line " + lineNumber + " undetermined");
            }
            this.undeterminedBranchSet.set(lineNumber);
        }
    }

    private static int getLineNumber(Method method, InstructionHandle handle) {
        LineNumberTable table = method.getCode().getLineNumberTable();
        if (table == null) {
            return -1;
        }
        return table.getSourceLine(handle.getPosition());
    }

    private void reportNullDeref(ClassContext classContext, Method method, InstructionHandle exceptionThrowerHandle, String type, int priority) {
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        BugInstance bugInstance = new BugInstance(type, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, exceptionThrowerHandle);
        if (DEBUG) {
            bugInstance.addInt(exceptionThrowerHandle.getPosition()).describe("INT_BYTECODE_OFFSET");
        }
        this.bugReporter.reportBug(bugInstance);
    }

    private void reportUselessControlFlow(ClassContext classContext, Method method, InstructionHandle handle) {
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        MethodGen methodGen = classContext.getMethodGen(method);
        this.bugReporter.reportBug(new BugInstance("RCN_REDUNDANT_COMPARISON_TO_NULL", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle));
    }

    public void report() {
    }

    private static class RedundantBranch {
        public final InstructionHandle handle;
        public final int lineNumber;

        public RedundantBranch(InstructionHandle handle, int lineNumber) {
            this.handle = handle;
            this.lineNumber = lineNumber;
        }

        public String toString() {
            return this.handle.toString() + ": line " + this.lineNumber;
        }
    }
}

