/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.bcp.Binding;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.bcp.IfNull;
import edu.umd.cs.findbugs.ba.bcp.Load;
import edu.umd.cs.findbugs.ba.bcp.Monitorenter;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.ba.bcp.Store;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class BCPDoubleCheck
extends ByteCodePatternDetector {
    private BugReporter bugReporter;
    private static final int MAX_WILD = 8;
    private static final int CREATE_OBJ_WILD = 60;
    private static final ByteCodePattern pattern = new ByteCodePattern();

    public BCPDoubleCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public ByteCodePattern getPattern() {
        return pattern;
    }

    public boolean prescreen(Method method, ClassContext classContext) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (!bytecodeSet.get(194)) {
            return false;
        }
        return bytecodeSet.get(180) && bytecodeSet.get(181) || bytecodeSet.get(178) && bytecodeSet.get(179);
    }

    public void reportMatch(JavaClass javaClass, MethodGen methodGen, ByteCodePatternMatch match) {
        BindingSet bindingSet = match.getBindingSet();
        Binding binding = bindingSet.lookup("h");
        FieldVariable field = (FieldVariable)binding.getVariable();
        if (field.getFieldName().startsWith("class$")) {
            return;
        }
        InstructionHandle start = match.getLabeledInstruction("startDC");
        InstructionHandle end = match.getLabeledInstruction("endDC");
        String sourceFile = javaClass.getSourceFileName();
        this.bugReporter.reportBug(new BugInstance("BCPDC_DOUBLECHECK", 2).addClassAndMethod(methodGen, sourceFile).addField(field).describe("FIELD_ON").addSourceLine(methodGen, sourceFile, start, end));
    }

    static {
        pattern.setInterElementWild(8).add(new Load("h", "x").label("startDC")).add((PatternElement)new IfNull("x")).add((PatternElement)new Monitorenter(pattern.dummyVariable())).add((PatternElement)new Load("h", "y")).add(new IfNull("y").label("endDC")).addWild(60).add((PatternElement)new Store("h", pattern.dummyVariable()));
    }
}

