/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Naming
extends PreorderVisitor
implements Detector,
Constants2 {
    String baseClassName;
    HashMap<String, HashSet<String>> canonicalToTrueMapping = new HashMap();
    HashMap<String, HashSet<MyMethod>> canonicalToMyMethod = new HashMap();
    HashSet<String> reported = new HashSet();
    HashSet<String> visited = new HashSet();
    private BugReporter bugReporter;

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            if (m2.superClass == null) {
                throw new RuntimeException("This is wrong");
            }
            if (!m.confusingMethodNames(m2) || !m.superClass.equals(m2.className)) continue;
            MyMethod m3 = new MyMethod(null, m.className, m2.methodName, m.methodSig);
            int size1 = others.size();
            boolean r = others.contains(m3);
            int size2 = others.size();
            if (size1 != size2) {
                throw new RuntimeException("this is wrong");
            }
            if (r) continue;
            this.bugReporter.reportBug(new BugInstance("NM_VERY_CONFUSING", 1).addClass(m.className).addMethod(m.className, m.methodName, m.methodSig).addClass(m2.className).addMethod(m2.className, m2.methodName, m2.methodSig));
            return true;
        }
        return false;
    }

    private boolean checkNonSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            if (!m.confusingMethodNames(m2)) continue;
            this.bugReporter.reportBug(new BugInstance("NM_CONFUSING", 3).addClass(m.className).addMethod(m.className, m.methodName, m.methodSig).addClass(m2.className).addMethod(m2.className, m2.methodName, m2.methodSig));
            return true;
        }
        return false;
    }

    public void report() {
        for (Map.Entry<String, HashSet<String>> e : this.canonicalToTrueMapping.entrySet()) {
            HashSet<String> s = e.getValue();
            if (s.size() <= 1) continue;
            String allSmall = e.getKey();
            HashSet<MyMethod> conflictingMethods = this.canonicalToMyMethod.get(allSmall);
            Iterator<MyMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            j = conflictingMethods.iterator();
            while (j.hasNext() && !this.checkNonSuper(j.next(), conflictingMethods)) {
            }
        }
    }

    public void visitJavaClass(JavaClass obj) {
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        try {
            JavaClass[] supers = Repository.getSuperClasses((JavaClass)obj);
            for (int i = 0; i < supers.length; ++i) {
                this.visitJavaClass(supers[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        super.visitJavaClass(obj);
    }

    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$.]");
        this.baseClassName = parts[parts.length - 1];
        super.visit(obj);
    }

    public void visit(Method obj) {
        if (this.methodName.length() == 1) {
            return;
        }
        if (this.methodName.equals(this.baseClassName)) {
            this.bugReporter.reportBug(new BugInstance("NM_CONFUSING_METHOD_NAME", 2).addClassAndMethod((BetterVisitor)this));
        }
        if (obj.isPrivate() || obj.isStatic()) {
            return;
        }
        String trueName = new StringBuffer().append(this.methodName).append(this.methodSig).toString();
        String allSmall = new StringBuffer().append(this.methodName.toLowerCase()).append(this.methodSig).toString();
        MyMethod mm = new MyMethod(this.betterSuperclassName, this.betterClassName, this.methodName, this.methodSig);
        HashSet<Object> s = this.canonicalToTrueMapping.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToTrueMapping.put(allSmall, s);
        }
        s.add(trueName);
        s = this.canonicalToMyMethod.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToMyMethod.put(allSmall, s);
        }
        s.add((String)((Object)mm));
        if (this.methodName.equals("hashcode") && this.methodSig.equals("()I")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_HASHCODE", 1).addClassAndMethod((BetterVisitor)this));
        }
        if (this.methodName.equals("tostring") && this.methodSig.equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_TOSTRING", 1).addClassAndMethod((BetterVisitor)this));
        }
    }

    static class MyMethod {
        final String superClass;
        final String className;
        final String methodName;
        final String methodSig;

        MyMethod(String sc, String c, String n, String s) {
            this.superClass = sc;
            this.className = c;
            this.methodName = n;
            this.methodSig = s;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyMethod)) {
                return false;
            }
            MyMethod m2 = (MyMethod)o;
            return this.className.equals(m2.className) && this.methodName.equals(m2.methodName) && this.methodSig.equals(m2.methodSig);
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode() + this.methodSig.hashCode();
        }

        public boolean confusingMethodNames(MyMethod m) {
            return this.methodName.equalsIgnoreCase(m.methodName) & !this.methodName.equals(m.methodName);
        }

        public String toString() {
            return this.superClass + " -> " + this.className + "." + this.methodName + ":" + this.methodSig;
        }
    }
}

