/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.AnalysisException;
import edu.umd.cs.daveho.ba.CFG;
import edu.umd.cs.daveho.ba.CFGBuilderException;
import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.daveho.ba.DataflowAnalysisException;
import edu.umd.cs.daveho.ba.InnerClassAccess;
import edu.umd.cs.daveho.ba.InnerClassAccessMap;
import edu.umd.cs.daveho.ba.InstanceField;
import edu.umd.cs.daveho.ba.Location;
import edu.umd.cs.daveho.ba.LocationScanner;
import edu.umd.cs.daveho.ba.LockDataflow;
import edu.umd.cs.daveho.ba.LockSet;
import edu.umd.cs.daveho.ba.Lookup;
import edu.umd.cs.daveho.ba.SignatureConverter;
import edu.umd.cs.daveho.ba.TypeDataflow;
import edu.umd.cs.daveho.ba.TypeFrame;
import edu.umd.cs.daveho.ba.ValueNumber;
import edu.umd.cs.daveho.ba.ValueNumberAnalysis;
import edu.umd.cs.daveho.ba.ValueNumberDataflow;
import edu.umd.cs.daveho.ba.ValueNumberFrame;
import edu.umd.cs.daveho.ba.XField;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CallGraph;
import edu.umd.cs.findbugs.CallGraphEdge;
import edu.umd.cs.findbugs.CallGraphNode;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SelfCalls;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindInconsistentSync2
implements Detector {
    private static final boolean DEBUG = Boolean.getBoolean("fis.debug");
    private static final boolean SYNC_ACCESS = Boolean.getBoolean("fis.syncAccess");
    private static final boolean ADJUST_SUBCLASS_ACCESSES = !Boolean.getBoolean("fis.noAdjustSubclass");
    private static final int UNLOCKED = 0;
    private static final int LOCKED = 1;
    private static final int READ = 0;
    private static final int WRITE = 2;
    private static final int READ_UNLOCKED = 0;
    private static final int WRITE_UNLOCKED = 2;
    private static final int READ_LOCKED = 1;
    private static final int WRITE_LOCKED = 3;
    private BugReporter bugReporter;
    private Map<XField, FieldStats> statMap = new HashMap<XField, FieldStats>();

    public FindInconsistentSync2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass javaClass = classContext.getJavaClass();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("******** Analyzing class ").append(javaClass.getClassName()).toString());
            }
            SelfCalls selfCalls = new SelfCalls(classContext){

                public boolean wantCallsFor(Method method) {
                    return !method.isPublic();
                }
            };
            selfCalls.execute();
            CallGraph callGraph = selfCalls.getCallGraph();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Call graph (not unlocked methods): ").append(callGraph.getNumVertices()).append(" nodes, ").append(callGraph.getNumEdges()).append(" edges").toString());
            }
            Set<CallSite> obviouslyLockedSites = this.findObviouslyLockedCallSites(classContext, selfCalls);
            Set<Method> lockedMethodSet = this.findNotUnlockedMethods(classContext, selfCalls, obviouslyLockedSites);
            lockedMethodSet.retainAll(this.findLockedMethods(classContext, selfCalls, obviouslyLockedSites));
            Set<Method> publicReachableMethods = this.findPublicReachableMethods(classContext, selfCalls);
            for (Method method : publicReachableMethods) {
                if (classContext.getMethodGen(method) == null || FindInconsistentSync2.isConstructor(method.getName()) || method.getName().startsWith("access$")) continue;
                this.analyzeMethod(classContext, method, lockedMethodSet);
            }
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException(new StringBuffer().append("FindInconsistentSync2 caught exception: ").append(e.toString()).toString(), (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            e.printStackTrace();
            throw new AnalysisException(new StringBuffer().append("FindInconsistentSync2 caught exception: ").append(e.toString()).toString(), (Throwable)e);
        }
    }

    public void report() {
        for (Map.Entry<XField, FieldStats> entry : this.statMap.entrySet()) {
            SourceLineAnnotation accessSourceLine;
            int priority;
            int freq;
            XField xfield = entry.getKey();
            FieldStats stats = entry.getValue();
            int numReadUnlocked = stats.getNumAccesses(0);
            int numWriteUnlocked = stats.getNumAccesses(2);
            int numReadLocked = stats.getNumAccesses(1);
            int numWriteLocked = stats.getNumAccesses(3);
            int locked = numReadLocked + numWriteLocked;
            int biasedLocked = numReadLocked + 2 * numWriteLocked;
            int unlocked = numReadUnlocked + numWriteUnlocked;
            int biasedUnlocked = numReadUnlocked + 2 * numWriteUnlocked;
            int writes = numWriteLocked + numWriteUnlocked;
            if (locked == 0 || unlocked == 0 || numReadUnlocked > 0 && 2 * biasedUnlocked > biasedLocked || numWriteUnlocked + numWriteLocked == 0 || stats.getNumLocalLocks() == 0 || (freq = 100 * locked / (locked + unlocked)) < 50) continue;
            int n = priority = freq > 75 ? 2 : 3;
            if (stats.getNumGetterMethodAccesses() >= unlocked) {
                priority = 3;
            }
            BugInstance bugInstance = new BugInstance("IS2_INCONSISTENT_SYNC", priority).addClass(xfield.getClassName()).addField(xfield).addInt(freq).describe("INT_SYNC_PERCENT");
            Iterator<SourceLineAnnotation> j = stats.unsyncAccessIterator();
            while (j.hasNext()) {
                accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_UNSYNC_ACCESS");
            }
            if (SYNC_ACCESS) {
                j = stats.syncAccessIterator();
                while (j.hasNext()) {
                    accessSourceLine = j.next();
                    bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_SYNC_ACCESS");
                }
            }
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private static boolean isConstructor(String methodName) {
        return methodName.equals("<init>") || methodName.equals("<clinit>") || methodName.equals("readObject") || methodName.equals("clone") || methodName.equals("close") || methodName.equals("finalize") || methodName.equals("this");
    }

    private void analyzeMethod(final ClassContext classContext, final Method method, final Set<Method> lockedMethodSet) throws CFGBuilderException, DataflowAnalysisException {
        final InnerClassAccessMap icam = InnerClassAccessMap.instance();
        final ConstantPoolGen cpg = classContext.getConstantPoolGen();
        final MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        final LockDataflow lockDataflow = classContext.getLockDataflow(method);
        final ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        final boolean isGetterMethod = FindInconsistentSync2.isGetterMethod(classContext, method);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("**** Analyzing method ").append(SignatureConverter.convertMethodSignature((MethodGen)classContext.getMethodGen(method))).toString());
        }
        new LocationScanner(cfg).scan(new LocationScanner.Callback(){

            public void visitLocation(Location location) throws CFGBuilderException, DataflowAnalysisException {
                try {
                    INVOKESTATIC inv;
                    InnerClassAccess access;
                    Instruction ins = location.getHandle().getInstruction();
                    XField xfield = null;
                    boolean isWrite = false;
                    boolean isLocal = false;
                    if (ins instanceof FieldInstruction) {
                        FieldInstruction fins = (FieldInstruction)ins;
                        xfield = Lookup.findXField((FieldInstruction)fins, (ConstantPoolGen)cpg);
                        isWrite = ins.getOpcode() == 181;
                        isLocal = fins.getClassName(cpg).equals(classContext.getJavaClass().getClassName());
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("Handling field access: ").append(location.getHandle()).append(" (frame=").append(vnaDataflow.getFactAtLocation(location)).append(")").toString());
                        }
                    } else if (ins instanceof INVOKESTATIC && (access = icam.getInnerClassAccess(inv = (INVOKESTATIC)ins, cpg)) != null && access.getMethodSignature().equals(inv.getSignature(cpg))) {
                        xfield = access.getField();
                        isWrite = !access.isLoad();
                        isLocal = false;
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("Handling inner class access: ").append(location.getHandle()).append(" (frame=").append(vnaDataflow.getFactAtLocation(location)).append(")").toString());
                        }
                    }
                    if (!(xfield == null || xfield.isStatic() || xfield.isPublic() || xfield.isVolatile() || xfield.isFinal())) {
                        TypeDataflow typeDataflow;
                        TypeFrame typeFrame;
                        Type instanceType;
                        boolean isLocked;
                        ValueNumberFrame frame = vnaDataflow.getFactAtLocation(location);
                        ValueNumber thisValue = !method.isStatic() ? ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getThisValue() : null;
                        LockSet lockSet = lockDataflow.getFactAtLocation(location);
                        InstructionHandle handle = location.getHandle();
                        ValueNumber instance = (ValueNumber)frame.getInstance(handle.getInstruction(), cpg);
                        boolean isExplicitlyLocked = lockSet.getLockCount(instance.getNumber()) > 0;
                        boolean isAccessedThroughThis = thisValue != null && thisValue.equals((Object)instance);
                        boolean bl = isLocked = isExplicitlyLocked || lockedMethodSet.contains(method) && isAccessedThroughThis || lockSet.containsReturnValue(((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactory());
                        if (ADJUST_SUBCLASS_ACCESSES && (instanceType = (Type)(typeFrame = (typeDataflow = classContext.getTypeDataflow(method)).getFactAtLocation(location)).getInstance(handle.getInstruction(), cpg)) != TypeFrame.getNullType()) {
                            if (!(instanceType instanceof ObjectType)) {
                                throw new AnalysisException(new StringBuffer().append("Field accessed through non-object reference ").append(instanceType).toString(), methodGen, handle);
                            }
                            ObjectType objType = (ObjectType)instanceType;
                            String instanceClassName = objType.getClassName();
                            if (!instanceClassName.equals(xfield.getClassName())) {
                                xfield = new InstanceField(instanceClassName, xfield.getFieldName(), xfield.getFieldSignature(), xfield.getAccessFlags());
                            }
                        }
                        int kind = 0;
                        kind |= isLocked ? 1 : 0;
                        kind |= isWrite ? 2 : 0;
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("IS2:\t").append(SignatureConverter.convertMethodSignature((MethodGen)classContext.getMethodGen(method))).append("\t").append(xfield).append("\t").append(isWrite ? "W" : "R").append("/").append(isLocked ? "L" : "U").toString());
                        }
                        FieldStats stats = FindInconsistentSync2.this.getStats(xfield);
                        stats.addAccess(kind);
                        if (isExplicitlyLocked && isLocal) {
                            stats.addLocalLock();
                        }
                        if (isGetterMethod && !isLocked) {
                            stats.addGetterMethodAccess();
                        }
                        stats.addAccess(classContext, method, handle, isLocked);
                    }
                }
                catch (ClassNotFoundException e) {
                    FindInconsistentSync2.this.bugReporter.reportMissingClass(e);
                }
            }
        });
    }

    public static boolean isGetterMethod(ClassContext classContext, Method method) {
        MethodGen methodGen = classContext.getMethodGen(method);
        InstructionList il = methodGen.getInstructionList();
        if (il.getLength() > 60) {
            return false;
        }
        int count = 0;
        for (InstructionHandle ih : il) {
            switch (ih.getInstruction().getOpcode()) {
                case 180: {
                    if (++count <= 1) break;
                    return false;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 181: {
                    return false;
                }
            }
        }
        return true;
    }

    private FieldStats getStats(XField field) {
        FieldStats stats = this.statMap.get(field);
        if (stats == null) {
            stats = new FieldStats();
            this.statMap.put(field, stats);
        }
        return stats;
    }

    private Set<Method> findNotUnlockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        lockedMethodSet.addAll(Arrays.asList(methodList));
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (!method.isPublic() || FindInconsistentSync2.isConstructor(method.getName())) continue;
            lockedMethodSet.remove(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (obviouslyLockedSites.contains(callSite) || lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.remove((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently not unlocked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return lockedMethodSet;
    }

    private Set<Method> findLockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (!method.isSynchronized()) continue;
            lockedMethodSet.add(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (!obviouslyLockedSites.contains(callSite) && !lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.add((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently locked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return lockedMethodSet;
    }

    private Set<Method> findPublicReachableMethods(ClassContext classContext, SelfCalls selfCalls) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> publicReachableMethodSet = new HashSet<Method>();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (!method.isPublic() || FindInconsistentSync2.isConstructor(method.getName())) continue;
            publicReachableMethodSet.add(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (!publicReachableMethodSet.contains(callSite.getMethod()) || !publicReachableMethodSet.add((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Methods apparently reachable from public non-constructor methods:");
            for (Method method : publicReachableMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return publicReachableMethodSet;
    }

    private Set<CallSite> findObviouslyLockedCallSites(ClassContext classContext, SelfCalls selfCalls) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        HashSet<CallSite> obviouslyLockedSites = new HashSet<CallSite>();
        Iterator i = selfCalls.callSiteIterator();
        while (i.hasNext()) {
            CallSite callSite = (CallSite)i.next();
            Method method = callSite.getMethod();
            Location location = callSite.getLocation();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (ins.getOpcode() == 184) continue;
            LockDataflow lockDataflow = classContext.getLockDataflow(method);
            LockSet lockSet = lockDataflow.getFactAtLocation(location);
            ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
            ValueNumberFrame frame = vnaDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            int numConsumed = ins.consumeStack(cpg);
            if (numConsumed == -2) {
                throw new AnalysisException(new StringBuffer().append("Unpredictable stack consumption: ").append(handle).toString());
            }
            ValueNumber instance = (ValueNumber)frame.getStackValue(numConsumed - 1);
            int lockCount = lockSet.getLockCount(instance.getNumber());
            if (lockCount <= 0) continue;
            obviouslyLockedSites.add(callSite);
        }
        return obviouslyLockedSites;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldStats {
        private int[] countList = new int[4];
        private int numLocalLocks = 0;
        private int numGetterMethodAccesses = 0;
        private LinkedList<SourceLineAnnotation> unsyncAccessList = new LinkedList();
        private LinkedList<SourceLineAnnotation> syncAccessList = new LinkedList();

        private FieldStats() {
        }

        public void addAccess(int kind) {
            int n = kind;
            this.countList[n] = this.countList[n] + 1;
        }

        public int getNumAccesses(int kind) {
            return this.countList[kind];
        }

        public void addLocalLock() {
            ++this.numLocalLocks;
        }

        public int getNumLocalLocks() {
            return this.numLocalLocks;
        }

        public void addGetterMethodAccess() {
            ++this.numGetterMethodAccesses;
        }

        public int getNumGetterMethodAccesses() {
            return this.numGetterMethodAccesses;
        }

        public void addAccess(ClassContext classContext, Method method, InstructionHandle handle, boolean isLocked) {
            if (!SYNC_ACCESS && isLocked) {
                return;
            }
            JavaClass javaClass = classContext.getJavaClass();
            String sourceFile = javaClass.getSourceFileName();
            MethodGen methodGen = classContext.getMethodGen(method);
            SourceLineAnnotation accessSourceLine = SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            if (accessSourceLine != null) {
                (isLocked ? this.syncAccessList : this.unsyncAccessList).add(accessSourceLine);
            }
        }

        public Iterator<SourceLineAnnotation> unsyncAccessIterator() {
            return this.unsyncAccessList.iterator();
        }

        public Iterator<SourceLineAnnotation> syncAccessIterator() {
            return this.syncAccessList.iterator();
        }
    }
}

