/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.daveho.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.daveho.ba.bcp.ByteCodePattern;
import edu.umd.cs.daveho.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.daveho.ba.bcp.Invoke;
import edu.umd.cs.daveho.ba.bcp.MatchAny;
import edu.umd.cs.daveho.ba.bcp.Opcode;
import edu.umd.cs.daveho.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class BCPMethodReturnCheck
extends ByteCodePatternDetector {
    private final BugReporter bugReporter;
    private final ByteCodePattern pattern;

    public BCPMethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.pattern = new ByteCodePattern().add(new MatchAny(new PatternElement[]{new Invoke("java.lang.String", "/.*", "/\\(.*\\)Ljava/lang/String;", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("java.lang.StringBuffer", "toString", "()Ljava/lang/String;", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("+java.lang.Thread", "<init>", "/.*", 4, (RepositoryLookupFailureCallback)bugReporter), new Invoke("java.security.MessageDigest", "digest", "([B)[B", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("+java.net.InetAddress", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("java.math.BigDecimal", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("java.math.BigInteger", "/.*", "/.*", 1, (RepositoryLookupFailureCallback)bugReporter), new Invoke("java.io.File", "createNewFile", "()Z", 1, (RepositoryLookupFailureCallback)bugReporter)}).label("call").setAllowTrailingEdges(false)).add((PatternElement)new MatchAny(new PatternElement[]{new Opcode(87), new Opcode(88)}));
    }

    public ByteCodePattern getPattern() {
        return this.pattern;
    }

    public boolean prescreen(Method method, ClassContext classContext) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(87) || bytecodeSet.get(88);
    }

    public void reportMatch(JavaClass javaClass, MethodGen methodGen, ByteCodePatternMatch match) {
        InstructionHandle call = match.getLabeledInstruction("call");
        InvokeInstruction inv = (InvokeInstruction)call.getInstruction();
        String calledMethodName = inv.getMethodName(methodGen.getConstantPool());
        if (calledMethodName.startsWith("access$")) {
            return;
        }
        String sourceFile = javaClass.getSourceFileName();
        this.bugReporter.reportBug(new BugInstance("RV_RETURN_VALUE_IGNORED", calledMethodName.equals("createNewFile") ? 3 : 2).addClassAndMethod(methodGen, sourceFile).addCalledMethod(methodGen, inv).addSourceLine(methodGen, sourceFile, call));
    }
}

