/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class Naming
extends PreorderVisitor
implements Detector,
Constants2 {
    String baseClassName;
    HashMap<String, String> classes = new HashMap();
    HashMap<String, String> canonicalNames = new HashMap();
    HashMap<String, String> canonicalSigs = new HashMap();
    HashSet<String> reported = new HashSet();
    private BugReporter bugReporter;

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
        String[] parts = this.betterClassName.split("[.]");
        this.baseClassName = parts[parts.length - 1];
    }

    public void visit(Method obj) {
        if (this.methodName.length() == 1) {
            return;
        }
        String allSmall = this.methodName.toLowerCase() + this.methodSig;
        this.classes.put(this.methodName, this.betterClassName);
        String old = this.canonicalNames.put(allSmall, this.methodName);
        String oldSig = this.canonicalSigs.put(allSmall, this.methodSig);
        if (old != null && !old.equals(this.methodName) && !this.reported.contains(allSmall)) {
            this.reported.add(allSmall);
            String oldClass = this.classes.get(old);
            if (this.betterSuperclassName.equals(oldClass)) {
                this.bugReporter.reportBug(new BugInstance("NM_VERY_CONFUSING", 1).addClass(this.betterClassName).addMethod(this.betterClassName, this.methodName, this.methodSig).addClass(this.classes.get(old)).addMethod(this.classes.get(old), old, oldSig));
            } else {
                this.bugReporter.reportBug(new BugInstance("NM_CONFUSING", 3).addClass(this.betterClassName).addMethod(this.betterClassName, this.methodName, this.methodSig).addClass(this.classes.get(old)).addMethod(this.classes.get(old), old, oldSig));
            }
        }
        if (this.methodName.equals(this.baseClassName)) {
            this.bugReporter.reportBug(new BugInstance("NM_CONFUSING_METHOD_NAME", 2).addClassAndMethod((BetterVisitor)this));
        }
        if (this.methodName.equals("hashcode") && this.methodSig.equals("()I")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_HASHCODE", 1).addClassAndMethod((BetterVisitor)this));
        }
        if (this.methodName.equals("tostring") && this.methodSig.equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance("NM_LCASE_TOSTRING", 1).addClassAndMethod((BetterVisitor)this));
        }
    }
}

