/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class EqStringTest
extends BytecodeScanningDetector
implements Constants2 {
    boolean constantOnTOS = false;
    boolean callToInternSeen = false;
    private BugReporter bugReporter;
    String stringOnTop;

    public EqStringTest(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.constantOnTOS = false;
        this.callToInternSeen = false;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 18: {
                this.constantOnTOS = true;
                this.stringOnTop = this.stringConstant;
                return;
            }
            case 182: {
                if (!this.refConstant.equals("java.lang.String.intern : ()Ljava.lang.String;")) break;
                this.callToInternSeen = true;
                break;
            }
            case 165: 
            case 166: {
                if (!this.constantOnTOS || this.callToInternSeen) break;
                this.bugReporter.reportBug(new BugInstance("ES_COMPARING_STRINGS_WITH_EQ", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.PC));
                break;
            }
        }
        this.constantOnTOS = false;
    }
}

