/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.maven.plugins.jgitflow.MavenJGitFlowConfiguration;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.helper.MavenExecutionHelper;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.manager.MavenJGitFlowConfigManager;
import com.atlassian.maven.plugins.jgitflow.rewrite.ArtifactReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.MavenProjectRewriter;
import com.atlassian.maven.plugins.jgitflow.rewrite.ParentReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectReleaseVersionChange;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.jgit.api.errors.GitAPIException;

public abstract class AbstractFlowReleaseManager
extends AbstractLogEnabled
implements FlowReleaseManager {
    protected static final String ls = System.getProperty("line.separator");
    private static final SecureRandom random = new SecureRandom();
    protected ProjectHelper projectHelper;
    protected MavenProjectRewriter projectRewriter;
    protected MavenExecutionHelper mavenExecutionHelper;
    protected MavenJGitFlowConfigManager configManager;
    protected RuntimeInformation runtimeInformation;
    private boolean sshAgentConfigured = false;
    private boolean sshConsoleInstalled = false;
    private boolean headerWritten = false;

    protected void writeReportHeader(ReleaseContext ctx, JGitFlowReporter reporter) {
        if (!this.headerWritten) {
            String mvnVersion = this.runtimeInformation.getApplicationVersion().toString();
            Package mvnFlowPkg = this.getClass().getPackage();
            String mvnFlowVersion = mvnFlowPkg.getImplementationVersion();
            String shortName = this.getClass().getSimpleName();
            reporter.debugText(shortName, "# Maven JGitFlow Plugin").debugText(shortName, JGitFlowReporter.P).debugText(shortName, "  ## Configuration").debugText(shortName, JGitFlowReporter.EOL).debugText(shortName, "    Maven Version: " + mvnVersion).debugText(shortName, JGitFlowReporter.EOL).debugText(shortName, "    Maven JGitFlow Plugin Version: " + mvnFlowVersion).debugText(shortName, JGitFlowReporter.EOL).debugText(shortName, "    args: " + ctx.getArgs()).debugText(shortName, "    base dir: " + ctx.getBaseDir().getAbsolutePath()).debugText(shortName, "    default development version: " + ctx.getDefaultDevelopmentVersion()).debugText(shortName, "    default feature name: " + ctx.getDefaultFeatureName()).debugText(shortName, "    default release version: " + ctx.getDefaultReleaseVersion()).debugText(shortName, "    release branch version suffix: " + ctx.getReleaseBranchVersionSuffix()).debugText(shortName, "    tag message: " + ctx.getTagMessage()).debugText(shortName, "    allow snapshots: " + ctx.isAllowSnapshots()).debugText(shortName, "    auto version submodules: " + ctx.isAutoVersionSubmodules()).debugText(shortName, "    enable feature versions: " + ctx.isEnableFeatureVersions()).debugText(shortName, "    enable ssh agent: " + ctx.isEnableSshAgent()).debugText(shortName, "    feature rebase: " + ctx.isFeatureRebase()).debugText(shortName, "    interactive: " + ctx.isInteractive()).debugText(shortName, "    keep branch: " + ctx.isKeepBranch()).debugText(shortName, "    no build: " + ctx.isNoBuild()).debugText(shortName, "    no deploy: " + ctx.isNoDeploy()).debugText(shortName, "    no tag: " + ctx.isNoTag()).debugText(shortName, "    pushFeatures: " + ctx.isPushFeatures()).debugText(shortName, "    pushReleases: " + ctx.isPushReleases()).debugText(shortName, "    pushHotfixes: " + ctx.isPushHotfixes()).debugText(shortName, "    squash: " + ctx.isSquash()).debugText(shortName, "    update dependencies: " + ctx.isUpdateDependencies()).debugText(shortName, "    use release profile: " + ctx.isUseReleaseProfile()).debugText(shortName, JGitFlowReporter.HR);
            reporter.flush();
            this.headerWritten = true;
        }
    }

    protected void setupCredentialProviders(ReleaseContext ctx, JGitFlowReporter reporter) {
        if (!ctx.isRemoteAllowed()) {
            return;
        }
        if (!this.sshConsoleInstalled) {
            this.sshConsoleInstalled = this.projectHelper.setupUserPasswordCredentialsProvider(ctx, reporter);
        }
        if (!this.sshAgentConfigured) {
            this.sshAgentConfigured = this.projectHelper.setupSshCredentialsProvider(ctx, reporter);
        }
    }

    protected String getReleaseLabel(String key, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> releaseVersions = this.projectHelper.getReleaseVersions(key, reactorProjects, ctx);
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
        return releaseVersions.get(rootProjectId);
    }

    protected String getHotfixLabel(String key, ReleaseContext ctx, List<MavenProject> reactorProjects, MavenJGitFlowConfiguration config) throws JGitFlowReleaseException {
        Map<String, String> hotfixVersions = this.projectHelper.getHotfixVersions(key, reactorProjects, ctx, config.getLastReleaseVersions());
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
        return hotfixVersions.get(rootProjectId);
    }

    protected String getDevelopmentLabel(String key, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> developmentVersions = this.projectHelper.getDevelopmentVersions(key, reactorProjects, ctx);
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
        return developmentVersions.get(rootProjectId);
    }

    protected String getFeatureStartName(ReleaseContext ctx, JGitFlow flow) throws JGitFlowReleaseException {
        return this.projectHelper.getFeatureStartName(ctx, flow);
    }

    protected String getFeatureFinishName(ReleaseContext ctx, JGitFlow flow) throws JGitFlowReleaseException {
        return this.projectHelper.getFeatureFinishName(ctx, flow);
    }

    protected void updatePomsWithReleaseVersion(String key, final String releaseLabel, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> releaseSnapshotVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        final String releaseSuffix = StringUtils.isBlank((String)ctx.getReleaseBranchVersionSuffix()) ? "" : "-" + ctx.getReleaseBranchVersionSuffix();
        Map releaseVersions = Maps.transformValues(releaseSnapshotVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.equalsIgnoreCase(releaseLabel + releaseSuffix + "-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)(releaseSuffix + "-SNAPSHOT"));
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, releaseVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(releaseVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, releaseVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with release versions", e);
            }
        }
    }

    protected void updatePomsWithReleaseSnapshotVersion(String key, final String releaseLabel, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> releaseVersions = this.projectHelper.getReleaseVersions(key, reactorProjects, ctx);
        final String releaseSuffix = StringUtils.isBlank((String)ctx.getReleaseBranchVersionSuffix()) ? "" : "-" + ctx.getReleaseBranchVersionSuffix();
        Map releaseSnapshotVersions = Maps.transformValues(releaseVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.equalsIgnoreCase(releaseLabel)) {
                    return input + releaseSuffix + "-SNAPSHOT";
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, releaseSnapshotVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(releaseSnapshotVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, releaseSnapshotVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with release versions", e);
            }
        }
    }

    protected void updatePomsWithFeatureVersion(String key, final String featureVersion, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> featureVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map featureSuffixedVersions = Maps.transformValues(featureVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + "-" + featureVersion + "-SNAPSHOT";
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, featureSuffixedVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(featureSuffixedVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, featureSuffixedVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with feature versions", e);
            }
        }
    }

    protected void updatePomsWithNonFeatureVersion(String key, String featureVersion, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> featureSuffixedVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        final String featureSuffix = "-" + featureVersion + "-SNAPSHOT";
        Map featureVersions = Maps.transformValues(featureSuffixedVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith(featureSuffix)) {
                    return StringUtils.substringBeforeLast((String)input, (String)featureSuffix) + "-SNAPSHOT";
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, featureVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(featureVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, featureVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with non-feature versions", e);
            }
        }
    }

    protected void updatePomsWithVersionCopy(ReleaseContext ctx, List<MavenProject> projectsToUpdate, List<MavenProject> projectsWithVersions) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(this.randomName("copy"), projectsToUpdate);
        Map<String, String> releaseVersions = this.projectHelper.getOriginalVersions(this.randomName("copy"), projectsWithVersions);
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : projectsToUpdate) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, releaseVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(releaseVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, releaseVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with release versions", e);
            }
        }
    }

    protected void updatePomsWithPreviousVersions(String key, ReleaseContext ctx, List<MavenProject> reactorProjects, MavenJGitFlowConfiguration config) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> preHotfixVersions = config.getPreHotfixVersions();
        if (null == preHotfixVersions || preHotfixVersions.isEmpty()) {
            this.updatePomsWithDevelopmentVersion(key, ctx, reactorProjects);
            return;
        }
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, preHotfixVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(preHotfixVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, preHotfixVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with development versions", e);
            }
        }
    }

    protected void updatePomsWithHotfixVersion(String key, final String hotfixLabel, ReleaseContext ctx, List<MavenProject> reactorProjects, MavenJGitFlowConfiguration config) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> hotfixSnapshotVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map hotfixVersions = Maps.transformValues(hotfixSnapshotVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.equalsIgnoreCase(hotfixLabel + "-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT");
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, hotfixVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(hotfixVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, hotfixVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with hotfix versions", e);
            }
        }
    }

    protected void updatePomsWithHotfixSnapshotVersion(String key, final String hotfixLabel, ReleaseContext ctx, List<MavenProject> reactorProjects, MavenJGitFlowConfiguration config) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> hotfixVersions = this.projectHelper.getHotfixVersions(key, reactorProjects, ctx, config.getLastReleaseVersions());
        Map hotfixSnapshotVersions = Maps.transformValues(hotfixVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.equalsIgnoreCase(hotfixLabel)) {
                    return input + "-SNAPSHOT";
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, hotfixSnapshotVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(hotfixSnapshotVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, hotfixSnapshotVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with release versions", e);
            }
        }
    }

    protected void updatePomsWithDevelopmentVersion(String key, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> developmentVersions = this.projectHelper.getDevelopmentVersions(key, reactorProjects, ctx);
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, developmentVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(developmentVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, developmentVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with development versions", e);
            }
        }
    }

    protected void checkPomForSnapshot(List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        this.getLogger().info("Checking for SNAPSHOT version in projects...");
        boolean hasSnapshotProject = false;
        for (MavenProject project : reactorProjects) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            hasSnapshotProject = true;
            break;
        }
        if (!hasSnapshotProject) {
            throw new JGitFlowReleaseException("Unable to find SNAPSHOT version in reactor projects!");
        }
    }

    protected void checkPomForRelease(List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        this.getLogger().info("Checking for release version in projects...");
        boolean hasSnapshotProject = false;
        for (MavenProject project : reactorProjects) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            hasSnapshotProject = true;
            break;
        }
        if (hasSnapshotProject) {
            throw new JGitFlowReleaseException("Some reactor projects contain SNAPSHOT versions!");
        }
    }

    protected void logChanges(ProjectChangeset changes) {
        if (this.getLogger().isDebugEnabled()) {
            for (String desc : changes.getChangeDescriptionsOrSummaries()) {
                this.getLogger().debug("  " + desc);
            }
        }
    }

    protected MavenSession getSessionForBranch(JGitFlow flow, String branchName, List<MavenProject> originalProjects, MavenSession oldSession) throws GitAPIException, ReactorReloadException, IOException {
        String originalBranch = flow.git().getRepository().getBranch();
        flow.git().checkout().setName(branchName).call();
        MavenProject rootProject = ReleaseUtil.getRootProject(originalProjects);
        MavenSession newSession = this.mavenExecutionHelper.reloadReactor(rootProject, oldSession);
        flow.git().checkout().setName(originalBranch).call();
        return newSession;
    }

    protected String randomName(String base) {
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return base + Long.toString(n);
    }

    @Override
    public void deploy(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session, String buildNumber, String goals) throws JGitFlowReleaseException {
    }
}

