/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.jgitflow.api.util;

import com.atlassian.jgitflow.core.JGitFlowInfo;
import com.atlassian.maven.jgitflow.api.exception.MavenJGitFlowExtensionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;

public class JGitFlowCommitHelper {
    public static void commitAllChanges(JGitFlowInfo flow, String commitMessage) throws MavenJGitFlowExtensionException {
        try {
            Git git = flow.git();
            Status status = git.status().call();
            if (!status.isClean()) {
                git.add().addFilepattern(".").call();
                git.commit().setMessage(commitMessage).call();
            }
        }
        catch (GitAPIException e) {
            throw new MavenJGitFlowExtensionException("error committing changes: " + e.getMessage(), e);
        }
    }
}

