/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.command.AbstractBranchMergingCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.extension.HotfixFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.EmptyHotfixFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.MergeProcessExtensionWrapper;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.StringUtils;

public class HotfixFinishCommand
extends AbstractBranchMergingCommand<HotfixFinishCommand, ReleaseMergeResult> {
    private static final String SHORT_NAME = "hotfix-finish";
    private String message;
    private boolean noTag;
    private HotfixFinishExtension extension;

    public HotfixFinishCommand(String hotfixName, Git git, GitFlowConfiguration gfConfig) {
        super(hotfixName, git, gfConfig);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)hotfixName));
        this.message = "tagging hotfix " + hotfixName;
        this.noTag = false;
        this.extension = new EmptyHotfixFinishExtension();
    }

    @Override
    public ReleaseMergeResult call() throws JGitFlowGitAPIException, LocalBranchMissingException, DirtyWorkingTreeException, JGitFlowIOException, BranchOutOfDateException, JGitFlowExtensionException, NotInitializedException {
        String prefixedBranchName = this.runBeforeAndGetPrefixedBranchName(this.extension.before(), JGitFlowConstants.PREFIXES.HOTFIX);
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireLocalBranchExists(prefixedBranchName);
        this.enforcer().requireCleanWorkingTree(this.isAllowUntracked());
        MergeResult developResult = this.createEmptyMergeResult();
        MergeResult masterResult = this.createEmptyMergeResult();
        MergeResult releaseResult = this.createEmptyMergeResult();
        try {
            this.doFetchIfNeeded(this.extension);
            this.ensureLocalBranchesNotBehindRemotes(prefixedBranchName, this.gfConfig.getMaster(), this.gfConfig.getDevelop());
            this.checkoutTopicBranch(prefixedBranchName, this.extension);
            MergeProcessExtensionWrapper masterExtension = new MergeProcessExtensionWrapper(this.extension.beforeMasterCheckout(), this.extension.afterMasterCheckout(), this.extension.beforeMasterMerge(), this.extension.afterMasterMerge());
            masterResult = this.doMerge(prefixedBranchName, this.gfConfig.getMaster(), masterExtension);
            if (!this.noTag && masterResult.getMergeStatus().isSuccessful()) {
                this.doTag(this.gfConfig.getMaster(), this.message, masterResult, this.extension);
            }
            MergeProcessExtensionWrapper developExtension = new MergeProcessExtensionWrapper(this.extension.beforeDevelopCheckout(), this.extension.afterDevelopCheckout(), this.extension.beforeDevelopMerge(), this.extension.afterDevelopMerge());
            developResult = this.doMerge(this.gfConfig.getMaster(), this.gfConfig.getDevelop(), developExtension);
            boolean mergeSuccess = this.checkMergeResults(masterResult, developResult);
            if (mergeSuccess) {
                this.doPushIfNeeded(this.extension, !this.noTag, this.gfConfig.getDevelop(), this.gfConfig.getMaster(), prefixedBranchName);
            }
            if (this.releaseBranchExists()) {
                String releaseBranchName = this.getReleaseBranchName();
                MergeProcessExtensionWrapper releaseExtension = new MergeProcessExtensionWrapper(this.extension.beforeReleaseCheckout(), this.extension.afterReleaseCheckout(), this.extension.beforeReleaseMerge(), this.extension.afterReleaseMerge());
                releaseResult = this.doMerge(this.gfConfig.getMaster(), releaseBranchName, releaseExtension);
                boolean releaseMergeSuccess = this.checkMergeResults(releaseResult);
                if (releaseMergeSuccess) {
                    this.doPushIfNeeded(this.extension, !this.noTag, releaseBranchName);
                }
            }
            if (mergeSuccess) {
                this.cleanupBranchesIfNeeded(this.gfConfig.getDevelop(), prefixedBranchName);
            }
            this.reporter.infoText(this.getCommandName(), "checking out '" + this.gfConfig.getDevelop() + "'");
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
            this.runExtensionCommands(this.extension.after());
            ReleaseMergeResult releaseMergeResult = new ReleaseMergeResult(masterResult, developResult);
            return releaseMergeResult;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
    }

    private boolean releaseBranchExists() throws JGitFlowGitAPIException {
        boolean exists = false;
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey()));
        if (!branches.isEmpty()) {
            exists = true;
        }
        return exists;
    }

    private String getReleaseBranchName() throws JGitFlowGitAPIException {
        String branchName = "";
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey()));
        if (!branches.isEmpty()) {
            branchName = branches.get(0).getName();
        }
        return branchName;
    }

    @Override
    public HotfixFinishCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public HotfixFinishCommand setNoTag(boolean noTag) {
        this.noTag = noTag;
        return this;
    }

    public HotfixFinishCommand setExtension(HotfixFinishExtension extension) {
        this.extension = extension;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

