/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.google.common.base.Strings;
import org.eclipse.jgit.lib.Config;

public enum CoreEol implements Config.ConfigEnum
{
    LF("lf", "\n"),
    CRLF("crlf", "\r\n"),
    NATIVE("native", System.getProperty("line.separator"));

    public static CoreEol DEFAULT;
    public static final String CONFIG_KEY_EOL = "eol";
    private final String configValue;
    private final String eol;

    private CoreEol(String configValue, String eol) {
        this.configValue = configValue;
        this.eol = eol;
    }

    public String getEol() {
        return this.eol;
    }

    public static CoreEol getConfigValue(Config gitConfig) {
        return (CoreEol)gitConfig.getEnum((Enum[])CoreEol.values(), "core", null, CONFIG_KEY_EOL, (Enum)DEFAULT);
    }

    public static CoreEol fromString(String eol) {
        if (!Strings.isNullOrEmpty((String)eol)) {
            for (CoreEol type : CoreEol.values()) {
                if (!type.toConfigValue().equalsIgnoreCase(eol)) continue;
                return type;
            }
        }
        return null;
    }

    public static boolean isValid(String eol) {
        return null != CoreEol.fromString(eol);
    }

    public String toConfigValue() {
        return this.configValue;
    }

    public boolean matchConfigValue(String in) {
        return this.configValue.equalsIgnoreCase(in);
    }

    static {
        DEFAULT = NATIVE;
    }
}

