/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class FeatureRebaseCommand
extends AbstractGitFlowCommand<FeatureRebaseCommand, Void> {
    private static final String SHORT_NAME = "feature-rebase";

    public FeatureRebaseCommand(String branchName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(branchName, git, gfConfig, reporter);
    }

    @Override
    public Void call() throws NotInitializedException, JGitFlowGitAPIException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchMissingException {
        String prefixedBranchName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey()) + this.getBranchName();
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireCleanWorkingTree(this.isAllowUntracked());
        this.enforcer().requireLocalBranchExists(prefixedBranchName);
        try {
            this.git.checkout().setName(prefixedBranchName).call();
            this.git.rebase().call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        return null;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

