/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.util;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.HotfixBranchExistsException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.ReleaseBranchExistsException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.RemoteBranchMissingException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.util.CleanStatus;
import com.atlassian.jgitflow.core.util.GitHelper;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public class RequirementHelper {
    protected final Git git;
    protected final GitFlowConfiguration gfConfig;
    protected final JGitFlowReporter reporter;
    protected final String commandName;

    public RequirementHelper(Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter, String commandName) {
        this.git = git;
        this.gfConfig = gfConfig;
        this.reporter = reporter;
        this.commandName = commandName;
    }

    public void requireGitFlowInitialized() throws NotInitializedException, JGitFlowGitAPIException {
        if (!this.gfConfig.gitFlowIsInitialized()) {
            this.reporter.errorText(this.commandName, "requireGitFlowInitialized() failed");
            this.reporter.flush();
            throw new NotInitializedException("Git flow is not initialized in " + this.git.getRepository().getWorkTree().getPath());
        }
    }

    public void requireLocalBranchAbsent(String branch) throws LocalBranchExistsException, JGitFlowGitAPIException {
        if (GitHelper.localBranchExists(this.git, branch)) {
            this.reporter.errorText(this.commandName, "requireLocalBranchAbsent() failed: '" + branch + "' already exists");
            this.reporter.flush();
            throw new LocalBranchExistsException("local branch '" + branch + "' already exists");
        }
    }

    public void requireLocalBranchExists(String branch) throws LocalBranchMissingException, JGitFlowGitAPIException {
        if (!GitHelper.localBranchExists(this.git, branch)) {
            this.reporter.errorText(this.commandName, "localBranchExists() failed: '" + branch + "' does not exist");
            this.reporter.flush();
            throw new LocalBranchMissingException("local branch " + branch + " does not exist");
        }
    }

    public void requireRemoteBranchAbsent(String branch) throws RemoteBranchExistsException, JGitFlowGitAPIException {
        if (GitHelper.remoteBranchExists(this.git, branch, this.reporter)) {
            this.reporter.errorText(this.commandName, "requireRemoteBranchAbsent() failed: '" + branch + "' already exists");
            this.reporter.flush();
            throw new RemoteBranchExistsException("remote branch '" + branch + "' already exists");
        }
    }

    public void requireRemoteBranchExists(String branch) throws RemoteBranchMissingException, JGitFlowGitAPIException {
        if (!GitHelper.remoteBranchExists(this.git, branch, this.reporter)) {
            this.reporter.errorText(this.commandName, "requireRemoteBranchExists() failed: '" + branch + "' does not exist");
            this.reporter.flush();
            throw new RemoteBranchMissingException("remote branch " + branch + " does not exist");
        }
    }

    public void requireTagAbsent(String name) throws TagExistsException, JGitFlowGitAPIException {
        if (GitHelper.tagExists(this.git, name)) {
            this.reporter.errorText(this.commandName, "requireTagAbsent() failed: '" + name + "' already exists");
            this.reporter.flush();
            throw new TagExistsException("tag '" + name + "' already exists");
        }
    }

    public void requireLocalBranchNotBehindRemote(String branch) throws BranchOutOfDateException, JGitFlowIOException {
        this.reporter.debugMethod(this.commandName, "requireLocalBranchNotBehindRemote");
        boolean behind = GitHelper.localBranchBehindRemote(this.git, branch, this.reporter);
        if (behind) {
            this.reporter.errorText(this.commandName, "local branch '" + branch + "' is behind the remote branch");
            this.reporter.endMethod();
            this.reporter.flush();
            throw new BranchOutOfDateException("local branch '" + branch + "' is behind the remote branch");
        }
        this.reporter.endMethod();
    }

    public void requireCleanWorkingTree(boolean allowUntracked) throws DirtyWorkingTreeException, JGitFlowIOException, JGitFlowGitAPIException {
        CleanStatus cs = GitHelper.workingTreeIsClean(this.git, allowUntracked, this.reporter);
        if (cs.isNotClean()) {
            this.reporter.errorText(this.commandName, cs.getMessage());
            this.reporter.flush();
            throw new DirtyWorkingTreeException(cs.getMessage());
        }
    }

    public void requireNoExistingReleaseBranches() throws ReleaseBranchExistsException, JGitFlowGitAPIException {
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey()), this.reporter);
        if (!branches.isEmpty()) {
            this.reporter.errorText(this.commandName, "a release branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
            this.reporter.flush();
            throw new ReleaseBranchExistsException("a release branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
        }
    }

    public void requireNoExistingHotfixBranches() throws HotfixBranchExistsException, JGitFlowGitAPIException {
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey()), this.reporter);
        if (!branches.isEmpty()) {
            this.reporter.errorText(this.commandName, "a hotfix branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
            this.reporter.flush();
            throw new HotfixBranchExistsException("a hotfix branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
        }
    }

    public void requireCommitOnBranch(RevCommit commit, String branch) throws LocalBranchExistsException, JGitFlowGitAPIException, JGitFlowIOException {
        if (!GitHelper.isMergedInto(this.git, commit, branch)) {
            this.reporter.errorText(this.commandName, "requireCommitOnBranch() failed: '" + commit.getName() + "' is not on " + branch);
            this.reporter.flush();
            throw new LocalBranchExistsException("commit '" + commit.getName() + "' does not exist on " + branch);
        }
    }
}

