/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.extension.impl.EmptyReleaseStartExtension;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;

public class ReleasePublishCommand
extends AbstractGitFlowCommand<ReleasePublishCommand, Void> {
    private static final String SHORT_NAME = "release-publish";

    public ReleasePublishCommand(String branchName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(branchName, git, gfConfig, reporter);
    }

    @Override
    public Void call() throws NotInitializedException, JGitFlowGitAPIException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchMissingException, RemoteBranchExistsException, JGitFlowExtensionException {
        EmptyReleaseStartExtension extension = new EmptyReleaseStartExtension();
        String prefixedBranchName = this.runBeforeAndGetPrefixedBranchName(extension.before(), JGitFlowConstants.PREFIXES.RELEASE);
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireCleanWorkingTree(this.isAllowUntracked());
        this.enforcer().requireLocalBranchExists(prefixedBranchName);
        try {
            this.doFetchIfNeeded(extension);
            this.enforcer().requireRemoteBranchAbsent(prefixedBranchName);
            RefSpec branchSpec = new RefSpec(prefixedBranchName + ":" + "refs/heads/" + prefixedBranchName);
            this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
            this.git.fetch().setRemote("origin").call();
            StoredConfig config = this.git.getRepository().getConfig();
            config.setString("branch", prefixedBranchName, "remote", "origin");
            config.setString("branch", prefixedBranchName, "merge", "refs/heads/" + prefixedBranchName);
            config.save();
            this.git.checkout().setName(prefixedBranchName).call();
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
        return null;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

