/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.FeatureRebaseCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.MergeConflictsNotResolvedException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.util.FileHelper;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.IterableHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;

public class FeatureFinishCommand
extends AbstractGitFlowCommand<Void> {
    private static final String SHORT_NAME = "feature-finish";
    private final String branchName;
    private boolean fetchDevelop;
    private boolean rebase;
    private boolean keepBranch;
    private boolean forceDeleteBranch;
    private boolean squash;
    private boolean push;
    private boolean noMerge;

    public FeatureFinishCommand(String name, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)name));
        this.branchName = name;
        this.fetchDevelop = false;
        this.rebase = false;
        this.keepBranch = false;
        this.forceDeleteBranch = false;
        this.squash = false;
        this.push = false;
        this.noMerge = false;
    }

    @Override
    public FeatureFinishCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public FeatureFinishCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public FeatureFinishCommand setScmMessageSuffix(String scmMessageSuffix) {
        super.setScmMessageSuffix(scmMessageSuffix);
        return this;
    }

    @Override
    public Void call() throws NotInitializedException, JGitFlowGitAPIException, LocalBranchMissingException, JGitFlowIOException, DirtyWorkingTreeException, MergeConflictsNotResolvedException, BranchOutOfDateException {
        this.reporter.debugCommandCall(this.getCommandName());
        String prefixedBranchName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey()) + this.branchName;
        this.requireGitFlowInitialized();
        this.requireLocalBranchExists(prefixedBranchName);
        File flowDir = new File(this.git.getRepository().getDirectory(), ".gitflow");
        File mergeBase = new File(flowDir, "MERGE_BASE");
        if (!this.noMerge && mergeBase.exists()) {
            this.reporter.debugText(this.getCommandName(), "restoring from merge conflict. base: " + mergeBase.getAbsolutePath());
            if (GitHelper.workingTreeIsClean(this.git, this.isAllowUntracked(), this.reporter).isClean()) {
                String finishBase = FileHelper.readFirstLine(mergeBase);
                if (GitHelper.isMergedInto(this.git, prefixedBranchName, finishBase)) {
                    mergeBase.delete();
                    this.cleanupBranch(prefixedBranchName);
                    this.reporter.endCommand();
                    return null;
                }
                mergeBase.delete();
            } else {
                this.reporter.errorText(this.getCommandName(), "Merge conflicts are not resolved");
                this.reporter.endCommand();
                throw new MergeConflictsNotResolvedException("Merge conflicts are not resolved");
            }
        }
        this.requireCleanWorkingTree();
        boolean remoteFeatureExists = GitHelper.remoteBranchExists(this.git, prefixedBranchName, this.reporter);
        this.reporter.debugText(this.getCommandName(), "remote feature exists? " + remoteFeatureExists);
        try {
            RefSpec branchSpec;
            if (remoteFeatureExists && this.fetchDevelop) {
                branchSpec = new RefSpec("+refs/heads/" + prefixedBranchName + ":" + "refs/remotes/" + "origin/" + prefixedBranchName);
                RefSpec developSpec = new RefSpec("+refs/heads/" + this.gfConfig.getDevelop() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getDevelop());
                this.git.fetch().setRefSpecs(new RefSpec[]{branchSpec}).call();
                this.git.fetch().setRefSpecs(new RefSpec[]{developSpec}).call();
            }
            if (remoteFeatureExists) {
                this.requireLocalBranchNotBehindRemote(prefixedBranchName);
            }
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getDevelop(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getDevelop());
            }
            if (this.rebase) {
                FeatureRebaseCommand rebaseCommand = new FeatureRebaseCommand(this.branchName, this.git, this.gfConfig, this.reporter);
                rebaseCommand.setAllowUntracked(this.isAllowUntracked()).call();
            }
            if (!this.noMerge) {
                this.reporter.debugText(this.getCommandName(), "beginning merges...");
                this.git.checkout().setName(this.gfConfig.getDevelop()).call();
                Ref featureBranch = GitHelper.getLocalBranch(this.git, prefixedBranchName);
                RevCommit developCommit = GitHelper.getLatestCommit(this.git, this.gfConfig.getDevelop());
                RevCommit featureCommit = GitHelper.getLatestCommit(this.git, prefixedBranchName);
                List commitList = IterableHelper.asList(this.git.log().setMaxCount(2).addRange((AnyObjectId)developCommit, (AnyObjectId)featureCommit).call());
                MergeResult mergeResult = null;
                if (commitList.size() < 2) {
                    mergeResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.FF).include(featureBranch).call();
                    if (mergeResult.getMergeStatus().isSuccessful()) {
                        this.git.commit().setMessage(this.getScmMessagePrefix() + "merging '" + prefixedBranchName + "' into '" + this.gfConfig.getDevelop() + "'" + this.getScmMessageSuffix()).call();
                    }
                } else if (this.squash) {
                    mergeResult = this.git.merge().setSquash(true).include(featureBranch).call();
                    if (mergeResult.getMergeStatus().isSuccessful()) {
                        this.git.commit().setMessage(this.getScmMessagePrefix() + "squashing '" + prefixedBranchName + "' into '" + this.gfConfig.getDevelop() + "'" + this.getScmMessageSuffix()).call();
                    }
                    this.forceDeleteBranch = true;
                } else {
                    mergeResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).include(featureBranch).call();
                }
                if (null == mergeResult || mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.FAILED) || mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
                    FileHelper.createParentDirs(mergeBase);
                    FileUtils.createNewFile((File)mergeBase);
                    FileHelper.writeStringToFile(this.gfConfig.getDevelop(), mergeBase);
                    this.reporter.endCommand();
                    this.reporter.flush();
                    throw new MergeConflictsNotResolvedException("merge conflicts exist, please resolve!");
                }
            }
            this.reporter.debugText(this.getCommandName(), "do wee need to push? " + this.push);
            if (this.push) {
                this.reporter.debugText(this.getCommandName(), "does remote branch [" + prefixedBranchName + "] exist? " + GitHelper.remoteBranchExists(this.git, prefixedBranchName, this.reporter));
                if (GitHelper.remoteBranchExists(this.git, prefixedBranchName, this.reporter)) {
                    this.reporter.infoText(this.getCommandName(), "pushing feature branch");
                    branchSpec = new RefSpec(prefixedBranchName);
                    this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                }
            }
            this.cleanupBranch(prefixedBranchName);
        }
        catch (GitAPIException e) {
            this.reporter.endCommand();
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            this.reporter.endCommand();
            throw new JGitFlowIOException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
        return null;
    }

    private void cleanupBranch(String branch) throws JGitFlowGitAPIException, LocalBranchMissingException, DirtyWorkingTreeException, JGitFlowIOException {
        this.requireLocalBranchExists(branch);
        this.requireCleanWorkingTree();
        try {
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
            if (this.fetchDevelop) {
                RefSpec spec = new RefSpec(":refs/heads/" + branch);
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{spec}).call();
            }
            if (!this.keepBranch) {
                if (this.noMerge || this.forceDeleteBranch) {
                    this.git.branchDelete().setForce(true).setBranchNames(new String[]{branch}).call();
                } else {
                    this.git.branchDelete().setForce(false).setBranchNames(new String[]{branch}).call();
                }
            }
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
    }

    public FeatureFinishCommand setFetchDevelop(boolean fetch) {
        this.fetchDevelop = fetch;
        return this;
    }

    public FeatureFinishCommand setRebase(boolean rebase) {
        this.rebase = rebase;
        return this;
    }

    public FeatureFinishCommand setKeepBranch(boolean keep) {
        this.keepBranch = keep;
        return this;
    }

    public FeatureFinishCommand setForceDeleteBranch(boolean force) {
        this.forceDeleteBranch = force;
        return this;
    }

    public FeatureFinishCommand setSquash(boolean squash) {
        this.squash = squash;
        return this;
    }

    public FeatureFinishCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    public FeatureFinishCommand setNoMerge(boolean noMerge) {
        this.noMerge = noMerge;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

