/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.HotfixBranchExistsException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.ReleaseBranchExistsException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.RemoteBranchMissingException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.util.CleanStatus;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class AbstractGitFlowCommand<T>
implements Callable<T> {
    protected final Git git;
    protected final GitFlowConfiguration gfConfig;
    protected final JGitFlowReporter reporter;
    private boolean allowUntracked;
    private String scmMessagePrefix;
    private String scmMessageSuffix;

    protected AbstractGitFlowCommand(Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        Preconditions.checkNotNull(git);
        Preconditions.checkNotNull(gfConfig);
        Preconditions.checkNotNull(reporter);
        this.git = git;
        this.gfConfig = gfConfig;
        this.reporter = reporter;
        this.allowUntracked = false;
        this.scmMessagePrefix = "";
        this.scmMessageSuffix = "";
    }

    public AbstractGitFlowCommand setAllowUntracked(boolean allow) {
        this.allowUntracked = allow;
        return this;
    }

    public boolean isAllowUntracked() {
        return this.allowUntracked;
    }

    public String getScmMessagePrefix() {
        return this.scmMessagePrefix;
    }

    public AbstractGitFlowCommand setScmMessagePrefix(String scmMessagePrefix) {
        this.scmMessagePrefix = scmMessagePrefix;
        return this;
    }

    public String getScmMessageSuffix() {
        return this.scmMessageSuffix;
    }

    public AbstractGitFlowCommand setScmMessageSuffix(String scmMessageSuffix) {
        this.scmMessageSuffix = scmMessageSuffix;
        return this;
    }

    protected void requireGitFlowInitialized() throws NotInitializedException, JGitFlowGitAPIException {
        if (!this.gfConfig.gitFlowIsInitialized()) {
            this.reporter.errorText(this.getCommandName(), "requireGitFlowInitialized() failed");
            this.reporter.flush();
            throw new NotInitializedException("Git flow is not initialized in " + this.git.getRepository().getWorkTree().getPath());
        }
    }

    protected abstract String getCommandName();

    protected void requireLocalBranchAbsent(String branch) throws LocalBranchExistsException, JGitFlowGitAPIException {
        if (GitHelper.localBranchExists(this.git, branch)) {
            this.reporter.errorText(this.getCommandName(), "requireLocalBranchAbsent() failed: '" + branch + "' already exists");
            this.reporter.flush();
            throw new LocalBranchExistsException("local branch '" + branch + "' already exists");
        }
    }

    protected void requireLocalBranchExists(String branch) throws LocalBranchMissingException, JGitFlowGitAPIException {
        if (!GitHelper.localBranchExists(this.git, branch)) {
            this.reporter.errorText(this.getCommandName(), "localBranchExists() failed: '" + branch + "' does not exist");
            this.reporter.flush();
            throw new LocalBranchMissingException("local branch " + branch + " does not exist");
        }
    }

    protected void requireRemoteBranchAbsent(String branch) throws RemoteBranchExistsException, JGitFlowGitAPIException {
        if (GitHelper.remoteBranchExists(this.git, branch, this.reporter)) {
            this.reporter.errorText(this.getCommandName(), "requireRemoteBranchAbsent() failed: '" + branch + "' already exists");
            this.reporter.flush();
            throw new RemoteBranchExistsException("remote branch '" + branch + "' already exists");
        }
    }

    protected void requireRemoteBranchExists(String branch) throws RemoteBranchMissingException, JGitFlowGitAPIException {
        if (!GitHelper.remoteBranchExists(this.git, branch, this.reporter)) {
            this.reporter.errorText(this.getCommandName(), "requireRemoteBranchExists() failed: '" + branch + "' does not exist");
            this.reporter.flush();
            throw new RemoteBranchMissingException("remote branch " + branch + " does not exist");
        }
    }

    protected void requireTagAbsent(String name) throws TagExistsException, JGitFlowGitAPIException {
        if (GitHelper.tagExists(this.git, name)) {
            this.reporter.errorText(this.getCommandName(), "requireTagAbsent() failed: '" + name + "' already exists");
            this.reporter.flush();
            throw new TagExistsException("tag '" + name + "' already exists");
        }
    }

    protected void requireLocalBranchNotBehindRemote(String branch) throws BranchOutOfDateException, JGitFlowIOException {
        this.reporter.debugMethod(this.getCommandName(), "requireLocalBranchNotBehindRemote");
        boolean behind = GitHelper.localBranchBehindRemote(this.git, branch, this.reporter);
        if (behind) {
            this.reporter.errorText(this.getCommandName(), "local branch '" + branch + "' is behind the remote branch");
            this.reporter.endMethod();
            this.reporter.flush();
            throw new BranchOutOfDateException("local branch '" + branch + "' is behind the remote branch");
        }
        this.reporter.endMethod();
    }

    protected void requireCleanWorkingTree() throws DirtyWorkingTreeException, JGitFlowIOException, JGitFlowGitAPIException {
        CleanStatus cs = GitHelper.workingTreeIsClean(this.git, this.isAllowUntracked(), this.reporter);
        if (cs.isNotClean()) {
            this.reporter.errorText(this.getCommandName(), cs.getMessage());
            this.reporter.flush();
            throw new DirtyWorkingTreeException(cs.getMessage());
        }
    }

    protected void requireNoExistingReleaseBranches() throws ReleaseBranchExistsException, JGitFlowGitAPIException {
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, JGitFlowConstants.PREFIXES.RELEASE.configKey(), this.reporter);
        if (!branches.isEmpty()) {
            this.reporter.errorText(this.getCommandName(), "a release branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
            this.reporter.flush();
            throw new ReleaseBranchExistsException("a release branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
        }
    }

    protected void requireNoExistingHotfixBranches() throws HotfixBranchExistsException, JGitFlowGitAPIException {
        List<Ref> branches = GitHelper.listBranchesWithPrefix(this.git, JGitFlowConstants.PREFIXES.HOTFIX.configKey(), this.reporter);
        if (!branches.isEmpty()) {
            this.reporter.errorText(this.getCommandName(), "a hotfix branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
            this.reporter.flush();
            throw new HotfixBranchExistsException("a hotfix branch [" + branches.get(0).getName() + "] already exists. Finish that first!");
        }
    }

    protected void requireCommitOnBranch(RevCommit commit, String branch) throws LocalBranchExistsException, JGitFlowGitAPIException, JGitFlowIOException {
        if (!GitHelper.isMergedInto(this.git, commit, branch)) {
            this.reporter.errorText(this.getCommandName(), "requireCommitOnBranch() failed: '" + commit.getName() + "' is not on " + branch);
            this.reporter.flush();
            throw new LocalBranchExistsException("commit '" + commit.getName() + "' does not exist on " + branch);
        }
    }
}

