/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.art;

import exchange.core2.collections.art.ArtNode4;
import exchange.core2.collections.art.IArtNode;
import exchange.core2.collections.art.LongObjConsumer;
import exchange.core2.collections.objpool.ObjectsPool;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LongAdaptiveRadixTreeMap<V> {
    private static final int INITIAL_LEVEL = 56;
    private IArtNode<V> root = null;
    private final ObjectsPool objectsPool;

    public LongAdaptiveRadixTreeMap(ObjectsPool objectsPool) {
        this.objectsPool = objectsPool;
    }

    public LongAdaptiveRadixTreeMap() {
        this.objectsPool = ObjectsPool.createDefaultTestPool();
    }

    public V get(long key) {
        return this.root != null ? (V)this.root.getValue(key, 56) : null;
    }

    public void put(long key, V value) {
        if (this.root == null) {
            ArtNode4 node = this.objectsPool.get(8, ArtNode4::new);
            node.initFirstKey(key, value);
            this.root = node;
        } else {
            IArtNode<V> upSizedNode = this.root.put(key, 56, value);
            if (upSizedNode != null) {
                this.root = upSizedNode;
            }
        }
    }

    public V getOrInsert(long key, Supplier<V> supplier) {
        return null;
    }

    public void getOrInsertFromNode(IArtNode<V> node, Supplier<V> supplier) {
    }

    public void remove(long key) {
        IArtNode<V> downSizeNode;
        if (this.root != null && (downSizeNode = this.root.remove(key, 56)) != this.root) {
            this.root = downSizeNode;
        }
    }

    public void clear() {
        this.root = null;
    }

    public void removeRange(long keyFromInclusive, long keyToExclusive) {
        throw new UnsupportedOperationException();
    }

    public V getHigherValue(long key) {
        if (this.root != null && key != Long.MAX_VALUE) {
            return this.root.getCeilingValue(key + 1L, 56);
        }
        return null;
    }

    public V getLowerValue(long key) {
        if (this.root != null && key != 0L) {
            return this.root.getFloorValue(key - 1L, 56);
        }
        return null;
    }

    public int forEach(LongObjConsumer<V> consumer, int limit) {
        if (this.root != null) {
            return this.root.forEach(consumer, limit);
        }
        return 0;
    }

    public int forEachDesc(LongObjConsumer<V> consumer, int limit) {
        if (this.root != null) {
            return this.root.forEachDesc(consumer, limit);
        }
        return 0;
    }

    public int size(int limit) {
        if (this.root != null) {
            return Math.min(this.root.size(limit), limit);
        }
        return 0;
    }

    public List<Map.Entry<Long, V>> entriesList() {
        if (this.root != null) {
            return this.root.entries();
        }
        return Collections.emptyList();
    }

    public void validateInternalState() {
        if (this.root != null) {
            this.root.validateInternalState(56);
        }
    }

    public String printDiagram() {
        if (this.root != null) {
            return this.root.printDiagram("", 56);
        }
        return "";
    }

    static <V> IArtNode<V> branchIfRequired(long key, V value, long nodeKey, int nodeLevel, IArtNode<V> caller) {
        long keyDiff = key ^ nodeKey;
        if ((keyDiff & -1L << nodeLevel) == 0L) {
            return null;
        }
        int newLevel = 63 - Long.numberOfLeadingZeros(keyDiff) & 0xF8;
        if (newLevel == nodeLevel) {
            return null;
        }
        ObjectsPool objectsPool = caller.getObjectsPool();
        ArtNode4 newSubNode = objectsPool.get(8, ArtNode4::new);
        newSubNode.initFirstKey(key, value);
        ArtNode4 newNode = objectsPool.get(8, ArtNode4::new);
        newNode.initTwoKeys(nodeKey, caller, key, newSubNode, newLevel);
        return newNode;
    }

    static String printDiagram(String prefix, int level, int nodeLevel, long nodeKey, short numChildren, Function<Short, Short> subKeys, Function<Short, Object> nodes) {
        String baseKeyPrefix1;
        String baseKeyPrefix;
        int lvlDiff = level - nodeLevel;
        if (lvlDiff != 0) {
            int chars = lvlDiff >> 2;
            long mask = (1L << lvlDiff) - 1L;
            baseKeyPrefix = LongAdaptiveRadixTreeMap.charRepeat('\u2500', chars - 2) + String.format("[%0" + chars + "X]", nodeKey >> nodeLevel + 8 & mask);
            baseKeyPrefix1 = LongAdaptiveRadixTreeMap.charRepeat(' ', chars * 2);
        } else {
            baseKeyPrefix = "";
            baseKeyPrefix1 = "";
        }
        StringBuilder sb = new StringBuilder();
        for (short i = 0; i < numChildren; i = (short)(i + 1)) {
            String x;
            Object node = nodes.apply(i);
            String key = String.format("%s%02X", baseKeyPrefix, subKeys.apply(i));
            String string = i == 0 ? (numChildren == 1 ? "\u2500\u2500" : "\u252c\u2500") : (x = i + 1 == numChildren ? prefix + "\u2514\u2500" : prefix + "\u251c\u2500");
            if (nodeLevel == 0) {
                sb.append(x + key + " = " + node);
            } else {
                sb.append(x + key + "" + ((IArtNode)node).printDiagram(prefix + (i + 1 == numChildren ? "    " : "\u2502   ") + baseKeyPrefix1, nodeLevel - 8));
            }
            if (i < numChildren - 1) {
                sb.append("\n");
                continue;
            }
            if (nodeLevel != 0) continue;
            sb.append("\n" + prefix);
        }
        return sb.toString();
    }

    private static String charRepeat(char x, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(x);
        }
        return sb.toString();
    }

    public static final class Entry<V>
    implements Map.Entry<Long, V> {
        final long key;
        V value;

        public Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V v = this.value;
            this.value = value;
            return v;
        }
    }
}

