/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.art;

import exchange.core2.collections.art.ArtNode4;
import exchange.core2.collections.art.ArtNode48;
import exchange.core2.collections.art.IArtNode;
import exchange.core2.collections.art.LongAdaptiveRadixTreeMap;
import exchange.core2.collections.art.LongObjConsumer;
import exchange.core2.collections.objpool.ObjectsPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ArtNode16<V>
implements IArtNode<V> {
    private static final int NODE4_SWITCH_THRESHOLD = 3;
    final short[] keys = new short[16];
    final Object[] nodes = new Object[16];
    long nodeKey;
    int nodeLevel;
    byte numChildren;
    private final ObjectsPool objectsPool;

    public ArtNode16(ObjectsPool objectsPool) {
        this.objectsPool = objectsPool;
    }

    void initFromNode4(ArtNode4<V> node4, short subKey, Object newElement) {
        int sourceSize = node4.numChildren;
        this.nodeLevel = node4.nodeLevel;
        this.nodeKey = node4.nodeKey;
        this.numChildren = (byte)(sourceSize + 1);
        byte inserted = 0;
        for (int i = 0; i < sourceSize; ++i) {
            short key = node4.keys[i];
            if (inserted == 0 && key > subKey) {
                this.keys[i] = subKey;
                this.nodes[i] = newElement;
                inserted = 1;
            }
            this.keys[i + inserted] = node4.keys[i];
            this.nodes[i + inserted] = node4.nodes[i];
        }
        if (inserted == 0) {
            this.keys[sourceSize] = subKey;
            this.nodes[sourceSize] = newElement;
        }
        Arrays.fill(node4.nodes, null);
        this.objectsPool.put(8, node4);
    }

    void initFromNode48(ArtNode48<V> node48) {
        this.numChildren = node48.numChildren;
        this.nodeLevel = node48.nodeLevel;
        this.nodeKey = node48.nodeKey;
        byte idx = 0;
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            byte j = node48.indexes[i];
            if (j != -1) {
                this.keys[idx] = i;
                this.nodes[idx] = node48.nodes[j];
                idx = (byte)(idx + 1);
            }
            if (idx == this.numChildren) break;
        }
        Arrays.fill(node48.nodes, null);
        Arrays.fill(node48.indexes, (byte)-1);
        this.objectsPool.put(10, node48);
    }

    @Override
    public V getValue(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return null;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = 0; i < this.numChildren; ++i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object node = this.nodes[i];
                return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getValue(key, this.nodeLevel - 8));
            }
            if (nodeIndex < index) break;
        }
        return null;
    }

    @Override
    public IArtNode<V> put(long key, int level, V value) {
        Object newElement;
        int pos;
        IArtNode<V> branch;
        if (level != this.nodeLevel && (branch = LongAdaptiveRadixTreeMap.branchIfRequired(key, value, this.nodeKey, this.nodeLevel, this)) != null) {
            return branch;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (pos = 0; pos < this.numChildren; ++pos) {
            if (nodeIndex == this.keys[pos]) {
                if (this.nodeLevel == 0) {
                    this.nodes[pos] = value;
                } else {
                    IArtNode<V> resizedNode = ((IArtNode)this.nodes[pos]).put(key, this.nodeLevel - 8, value);
                    if (resizedNode != null) {
                        this.nodes[pos] = resizedNode;
                    }
                }
                return null;
            }
            if (nodeIndex < this.keys[pos]) break;
        }
        if (this.numChildren != 16) {
            int copyLength = this.numChildren - pos;
            if (copyLength != 0) {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, copyLength);
                System.arraycopy(this.nodes, pos, this.nodes, pos + 1, copyLength);
            }
            this.keys[pos] = nodeIndex;
            if (this.nodeLevel == 0) {
                this.nodes[pos] = value;
            } else {
                ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
                newSubNode.initFirstKey(key, value);
                this.nodes[pos] = newSubNode;
                newSubNode.put(key, this.nodeLevel - 8, value);
            }
            this.numChildren = (byte)(this.numChildren + 1);
            return null;
        }
        if (this.nodeLevel == 0) {
            newElement = value;
        } else {
            ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
            newSubNode.initFirstKey(key, value);
            newElement = newSubNode;
        }
        ArtNode48 node48 = this.objectsPool.get(10, ArtNode48::new);
        node48.initFromNode16(this, nodeIndex, newElement);
        return node48;
    }

    @Override
    public IArtNode<V> remove(long key, int level) {
        int pos;
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return this;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        Object node = null;
        for (pos = 0; pos < this.numChildren; ++pos) {
            if (nodeIndex == this.keys[pos]) {
                node = this.nodes[pos];
                break;
            }
            if (nodeIndex >= this.keys[pos]) continue;
            return this;
        }
        if (node == null) {
            return this;
        }
        if (this.nodeLevel == 0) {
            this.removeElementAtPos(pos);
        } else {
            IArtNode resizedNode = ((IArtNode)node).remove(key, this.nodeLevel - 8);
            if (resizedNode != node) {
                this.nodes[pos] = resizedNode;
                if (resizedNode == null) {
                    this.removeElementAtPos(pos);
                }
            }
        }
        if (this.numChildren == 3) {
            ArtNode4 newNode = this.objectsPool.get(8, ArtNode4::new);
            newNode.initFromNode16(this);
            return newNode;
        }
        return this;
    }

    @Override
    public V getCeilingValue(long key, int level) {
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask < keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = 0L;
            }
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = 0; i < this.numChildren; ++i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object res;
                Object object = res = this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getCeilingValue(key, this.nodeLevel - 8);
                if (res != null) {
                    return (V)res;
                }
            }
            if (index <= nodeIndex) continue;
            return (V)(this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getCeilingValue(0L, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public V getFloorValue(long key, int level) {
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask > keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = Long.MAX_VALUE;
            }
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = this.numChildren - 1; i >= 0; --i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object res;
                Object object = res = this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getFloorValue(key, this.nodeLevel - 8);
                if (res != null) {
                    return (V)res;
                }
            }
            if (index >= nodeIndex) continue;
            return (V)(this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getFloorValue(Long.MAX_VALUE, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public int forEach(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int n = Math.min(this.numChildren, limit);
            for (int i = 0; i < n; ++i) {
                consumer.accept(keyBase + (long)this.keys[i], this.nodes[i]);
            }
            return n;
        }
        int numLeft = limit;
        for (int i = 0; i < this.numChildren && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).forEach(consumer, numLeft), ++i) {
        }
        return limit - numLeft;
    }

    @Override
    public int forEachDesc(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = this.numChildren - 1; i >= 0 && numFound < limit; ++numFound, --i) {
                consumer.accept(keyBase + (long)this.keys[i], this.nodes[i]);
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = this.numChildren - 1; i >= 0 && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).forEachDesc(consumer, numLeft), --i) {
        }
        return limit - numLeft;
    }

    @Override
    public int size(int limit) {
        if (this.nodeLevel == 0) {
            return this.numChildren;
        }
        int numLeft = limit;
        for (int i = this.numChildren - 1; i >= 0 && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).size(numLeft), --i) {
        }
        return limit - numLeft;
    }

    @Override
    public void validateInternalState(int level) {
        if (this.nodeLevel > level) {
            throw new IllegalStateException("unexpected nodeLevel");
        }
        if (this.numChildren > 16 || this.numChildren <= 3) {
            throw new IllegalStateException("unexpected numChildren");
        }
        short last = -1;
        for (int i = 0; i < 16; ++i) {
            Object node = this.nodes[i];
            if (i < this.numChildren) {
                if (node == null) {
                    throw new IllegalStateException("null node");
                }
                if (this.keys[i] < 0 || this.keys[i] >= 256) {
                    throw new IllegalStateException("key out of range");
                }
                if (this.keys[i] == last) {
                    throw new IllegalStateException("duplicate key");
                }
                if (this.keys[i] < last) {
                    throw new IllegalStateException("wrong key order");
                }
                last = this.keys[i];
                if (node instanceof IArtNode) {
                    if (this.nodeLevel == 0) {
                        throw new IllegalStateException("unexpected node type");
                    }
                    IArtNode artNode = (IArtNode)node;
                    artNode.validateInternalState(this.nodeLevel - 8);
                    continue;
                }
                if (this.nodeLevel == 0) continue;
                throw new IllegalStateException("unexpected node type");
            }
            if (node == null) continue;
            throw new IllegalStateException("not released node");
        }
    }

    @Override
    public String printDiagram(String prefix, int level) {
        return LongAdaptiveRadixTreeMap.printDiagram(prefix, level, this.nodeLevel, this.nodeKey, this.numChildren, idx -> this.keys[idx], idx -> this.nodes[idx]);
    }

    @Override
    public List<Map.Entry<Long, V>> entries() {
        long keyPrefix = this.nodeKey & 0xFFFFFFFFFFFFFF00L;
        ArrayList<Map.Entry<Long, V>> list = new ArrayList<Map.Entry<Long, V>>();
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.nodeLevel == 0) {
                list.add(new LongAdaptiveRadixTreeMap.Entry<Object>(keyPrefix + (long)this.keys[i], this.nodes[i]));
                continue;
            }
            list.addAll(((IArtNode)this.nodes[i]).entries());
        }
        return list;
    }

    private void removeElementAtPos(int pos) {
        int ppos = pos + 1;
        int copyLength = this.numChildren - ppos;
        if (copyLength != 0) {
            System.arraycopy(this.keys, ppos, this.keys, pos, copyLength);
            System.arraycopy(this.nodes, ppos, this.nodes, pos, copyLength);
        }
        this.numChildren = (byte)(this.numChildren - 1);
        this.nodes[this.numChildren] = null;
    }

    @Override
    public ObjectsPool getObjectsPool() {
        return this.objectsPool;
    }

    public String toString() {
        return "ArtNode16{nodeKey=" + this.nodeKey + ", nodeLevel=" + this.nodeLevel + ", numChildren=" + this.numChildren + '}';
    }
}

