/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.validation;

import java.util.ArrayList;
import java.util.List;

public final class ValidationResult {
    private final List m_warnings = new ArrayList(16);
    private final List m_errors = new ArrayList(16);
    private boolean m_valid;
    private boolean m_readOnly;

    public void addWarning(String warning) {
        this.checkWriteable();
        this.m_warnings.add(warning);
    }

    public void addError(String error) {
        this.checkWriteable();
        this.m_errors.add(error);
    }

    public void setResult(boolean valid) {
        this.checkWriteable();
        this.m_valid = valid;
        this.m_readOnly = true;
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    public List getErrors() {
        return this.m_errors;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ValidationResult is read only and can not be modified");
        }
    }
}

