/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.validation;

import java.io.InputStream;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.configuration.validation.ConfigurationValidator;
import org.apache.excalibur.configuration.validation.ConfigurationValidatorFactory;
import org.apache.excalibur.configuration.validation.JarvConfigurationValidator;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.SAXParseException;

public class JarvConfigurationValidatorFactory
extends AbstractLogEnabled
implements Configurable,
Initializable,
ConfigurationValidatorFactory {
    private String m_schemaType;
    private String m_schemaLanguage;
    private String m_verifierFactoryClass;
    private VerifierFactory m_verifierFactory;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_schemaType = configuration.getAttribute("schema-type");
        this.m_schemaLanguage = configuration.getChild("schema-language").getValue(null);
        this.m_verifierFactoryClass = configuration.getChild("verifier-factory-class").getValue(null);
        if (null == this.m_schemaLanguage && null == this.m_verifierFactoryClass || null != this.m_schemaLanguage && null != this.m_verifierFactoryClass) {
            String msg = "Must specify either schema-language or verifier-factory-class";
            throw new ConfigurationException("Must specify either schema-language or verifier-factory-class");
        }
    }

    public void initialize() throws Exception {
        if (null != this.m_schemaLanguage) {
            this.m_verifierFactory = VerifierFactory.newInstance((String)this.m_schemaLanguage);
        } else if (null != this.m_verifierFactoryClass) {
            this.m_verifierFactory = (VerifierFactory)Class.forName(this.m_verifierFactoryClass).newInstance();
        }
    }

    public ConfigurationValidator createValidator(String schemaType, InputStream schema) throws ConfigurationException {
        if (!this.m_schemaType.equals(schemaType)) {
            String msg = "Invalid schema type: " + schemaType + ". Validator only supports " + this.m_schemaType;
            throw new ConfigurationException(msg);
        }
        try {
            return new JarvConfigurationValidator(this.getLogger(), this.m_verifierFactory.compileSchema(schema));
        }
        catch (VerifierConfigurationException e) {
            String msg = "Unable to create schema";
            throw new ConfigurationException("Unable to create schema", (Throwable)e);
        }
        catch (SAXParseException e) {
            String msg = "Unable to parse schema [line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + ", msg: " + e.getMessage() + "]";
            throw new ConfigurationException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unable to parse schema [url: " + schema + ", msg: " + e.getMessage() + "]";
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }
}

