/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.validation;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.configuration.validation.ConfigurationValidator;
import org.apache.excalibur.configuration.validation.ValidationResult;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JarvConfigurationValidator
implements ConfigurationValidator {
    private final DefaultConfigurationSerializer m_serializer = new DefaultConfigurationSerializer();
    private final Logger m_logger;
    private final Schema m_schema;

    public JarvConfigurationValidator(Logger logger, Schema schema) {
        this.m_logger = logger;
        this.m_schema = schema;
    }

    public ValidationResult isFeasiblyValid(Configuration configuration) throws ConfigurationException {
        ValidationResult result = new ValidationResult();
        result.setResult(true);
        return result;
    }

    public ValidationResult isValid(Configuration configuration) throws ConfigurationException {
        final ValidationResult result = new ValidationResult();
        DefaultConfiguration branched = new DefaultConfiguration("root", configuration.getLocation());
        branched.addAll(configuration);
        branched.makeReadOnly();
        try {
            Verifier verifier = this.m_schema.newVerifier();
            VerifierHandler handler = verifier.getVerifierHandler();
            verifier.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    result.addWarning(exception.getMessage());
                }

                public void error(SAXParseException exception) throws SAXException {
                    result.addError(exception.getMessage());
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    result.addError(exception.getMessage());
                }
            });
            this.m_serializer.serialize((ContentHandler)handler, (Configuration)branched);
            result.setResult(handler.isValid());
            return result;
        }
        catch (VerifierConfigurationException e) {
            String message = "Unable to verify configuration";
            throw new ConfigurationException("Unable to verify configuration", (Throwable)e);
        }
        catch (SAXException e) {
            String message = "Unable to parse configuration";
            throw new ConfigurationException("Unable to parse configuration", (Throwable)e);
        }
        catch (IllegalStateException e) {
            String message = "Unable to parse configuration";
            throw new ConfigurationException("Unable to parse configuration", (Throwable)e);
        }
    }
}

