/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.validation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.configuration.validation.ConfigurationValidator;
import org.apache.excalibur.configuration.validation.ConfigurationValidatorFactory;
import org.apache.excalibur.configuration.validation.DelegateEntry;

public class DelegatingConfigurationValidatorFactory
extends AbstractLogEnabled
implements Configurable,
Initializable,
Disposable,
ConfigurationValidatorFactory {
    private Map m_delegates = new HashMap();
    private String m_supportedTypes;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] delegates = configuration.getChildren("delegate");
        StringBuffer types = new StringBuffer();
        int i = 0;
        while (i < delegates.length) {
            String type = delegates[i].getAttribute("schema-type");
            this.m_delegates.put(type, new DelegateEntry(type, delegates[i].getAttribute("class"), delegates[i]));
            if (i > 0) {
                types.append(",");
            }
            types.append(type);
            ++i;
        }
        this.m_supportedTypes = types.toString();
    }

    public void initialize() throws Exception {
        Iterator i = this.m_delegates.values().iterator();
        while (i.hasNext()) {
            DelegateEntry entry = (DelegateEntry)i.next();
            Class<?> clazz = Class.forName(entry.getClassName());
            ConfigurationValidatorFactory validator = (ConfigurationValidatorFactory)clazz.newInstance();
            ContainerUtil.enableLogging((Object)validator, (Logger)this.getLogger());
            ContainerUtil.configure((Object)validator, (Configuration)entry.getConfiguration());
            ContainerUtil.initialize((Object)validator);
            entry.setValidatorFactory(validator);
        }
    }

    public void dispose() {
        Iterator i = this.m_delegates.values().iterator();
        while (i.hasNext()) {
            ContainerUtil.dispose((Object)((DelegateEntry)i.next()).getValidatorFactory());
        }
    }

    public ConfigurationValidator createValidator(String schemaType, InputStream schema) throws ConfigurationException {
        DelegateEntry entry = (DelegateEntry)this.m_delegates.get(schemaType);
        if (entry == null) {
            String msg = "Invalid schema type: " + schemaType + ". Validator only supports: " + this.m_supportedTypes;
            throw new ConfigurationException(msg);
        }
        return entry.getValidatorFactory().createValidator(schemaType, schema);
    }
}

