/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration.merged;

import java.util.HashSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class ConfigurationSplitter {
    public static Configuration split(Configuration merged, Configuration base) throws ConfigurationException {
        DefaultConfiguration layer = ConfigurationSplitter.doSplit(merged, base, false);
        layer.makeReadOnly();
        return layer;
    }

    private static DefaultConfiguration doSplit(Configuration merged, Configuration base, boolean isMerged) throws ConfigurationException {
        DefaultConfiguration layer = new DefaultConfiguration(base.getName(), "Merged [merged: " + merged.getLocation() + ", base: " + base.getLocation() + "]");
        ConfigurationSplitter.copyAttributes(layer, merged, base);
        ConfigurationSplitter.copyValue(layer, merged, base);
        ConfigurationSplitter.copyChildren(layer, merged, base);
        if (isMerged) {
            layer.setAttribute("excalibur-configuration:merge", "true");
        }
        return layer;
    }

    private static DefaultConfiguration doSplit(Configuration merged, Configuration base, String keyAttr) throws ConfigurationException {
        DefaultConfiguration layer = ConfigurationSplitter.doSplit(merged, base, true);
        if (null != keyAttr) {
            layer.setAttribute("excalibur-configuration:key-attribute", keyAttr);
        }
        return layer;
    }

    private static void copyChildren(DefaultConfiguration layer, Configuration merged, Configuration base) throws ConfigurationException {
        Configuration[] kids = merged.getChildren();
        int i = 0;
        while (i < kids.length) {
            Configuration mergedWith;
            Configuration mergedChild = kids[i];
            String name = mergedChild.getName();
            Configuration[] mc = merged.getChildren(name);
            Configuration[] bc = base.getChildren(name);
            String keyAttr = null;
            if (bc.length > mc.length) {
                throw new UnsupportedOperationException("Unable to mask children from base in layer");
            }
            if (bc.length == 0) {
                mergedWith = null;
            } else if (mc.length == 1 && bc.length == 1) {
                mergedWith = bc[0];
            } else {
                String keyValue;
                keyAttr = ConfigurationSplitter.findUniqueAttributeName(mc);
                Configuration[] matches = ConfigurationUtil.match(base, name, keyAttr, keyValue = mergedChild.getAttribute(keyAttr));
                if (matches.length == 1) {
                    mergedWith = matches[0];
                } else {
                    throw new ConfigurationException("Multiple children in base with name '" + name + "' and attr '" + keyAttr + " = " + keyValue + "'");
                }
            }
            if (null == mergedWith) {
                layer.addChild(kids[i]);
            } else if (!ConfigurationUtil.equals(kids[i], mergedWith)) {
                DefaultConfiguration layerChild = ConfigurationSplitter.doSplit(kids[i], mergedWith, keyAttr);
                layerChild.makeReadOnly();
                layer.addChild((Configuration)layerChild);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String findUniqueAttributeName(Configuration[] c) throws ConfigurationException {
        HashSet<String> testedAttributes = new HashSet<String>();
        String uniqueAttr = null;
        int i = 0;
        while (i < c.length) {
            String[] attrs = c[i].getAttributeNames();
            int j = 0;
            while (j < attrs.length) {
                String attr = attrs[j];
                if (!testedAttributes.contains(attr) && ConfigurationSplitter.isUniqueAttribute(attr, c[i].getAttribute(attr), i, c)) {
                    if (null != uniqueAttr) throw new ConfigurationException("Multiple unique attributes for child [name: " + c[0].getName() + ", unique1: " + uniqueAttr + ", unique2: " + attr + "]");
                    uniqueAttr = attr;
                } else {
                    testedAttributes.add(attr);
                }
                ++j;
            }
            ++i;
        }
        if (null != uniqueAttr) return uniqueAttr;
        throw new ConfigurationException("Unable to find unique attribute for children of name: " + c[0].getName());
    }

    private static boolean isUniqueAttribute(String attr, String value, int currentConfig, Configuration[] c) {
        int i = 0;
        while (i < c.length) {
            if (i != currentConfig) {
                try {
                    if (value.equals(c[i].getAttribute(attr))) {
                        return false;
                    }
                }
                catch (ConfigurationException e) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static void copyValue(DefaultConfiguration layer, Configuration merged, Configuration base) {
        block3: {
            String value = merged.getValue(null);
            if (null == value) break block3;
            try {
                String baseValue = base.getValue();
                if (!value.equals(baseValue)) {
                    layer.setValue(value);
                }
            }
            catch (ConfigurationException e) {
                layer.setValue(value);
            }
        }
    }

    private static void copyAttributes(DefaultConfiguration layer, Configuration merged, Configuration base) throws ConfigurationException {
        String[] mergedAttr = merged.getAttributeNames();
        int i = 0;
        while (i < mergedAttr.length) {
            String value = merged.getAttribute(mergedAttr[i]);
            try {
                String baseValue = base.getAttribute(mergedAttr[i]);
                if (!value.equals(baseValue)) {
                    layer.setAttribute(mergedAttr[i], value);
                }
            }
            catch (ConfigurationException e) {
                layer.setAttribute(mergedAttr[i], value);
            }
            ++i;
        }
    }
}

