/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class ConfigurationUtil {
    public static String list(Configuration config) {
        StringBuffer buffer = new StringBuffer();
        ConfigurationUtil.list(buffer, "  ", config);
        buffer.append("\n");
        return buffer.toString();
    }

    private static void list(StringBuffer buffer, String lead, Configuration config) {
        Configuration[] children;
        buffer.append("\n" + lead + "<" + config.getName());
        String[] names = config.getAttributeNames();
        if (names.length > 0) {
            int i = 0;
            while (i < names.length) {
                buffer.append(" " + names[i] + "=\"" + config.getAttribute(names[i], "???") + "\"");
                ++i;
            }
        }
        if ((children = config.getChildren()).length > 0) {
            buffer.append(">");
            int j = 0;
            while (j < children.length) {
                ConfigurationUtil.list(buffer, lead + "  ", children[j]);
                ++j;
            }
            buffer.append("\n" + lead + "</" + config.getName() + ">");
        } else if (config.getValue(null) != null) {
            buffer.append(">" + config.getValue("") + "</" + config.getName() + ">");
        } else {
            buffer.append("/>");
        }
    }

    public static Configuration[] match(Configuration config, String element, String attribute) {
        return ConfigurationUtil.match(config, element, attribute, null);
    }

    public static Configuration[] match(Configuration config, String element, String attribute, String value) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        Configuration[] children = config.getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (null == attribute) {
                list.add(children[i]);
            } else {
                String v = children[i].getAttribute(attribute, null);
                if (v != null && (value == null || v.equals(value))) {
                    list.add(children[i]);
                }
            }
            ++i;
        }
        return list.toArray(new Configuration[list.size()]);
    }

    public static Configuration matchFirstOccurance(Configuration config, String element, String attribute, String value) {
        return ConfigurationUtil.matchFirstOccurance(config, element, attribute, value, true);
    }

    public static Configuration matchFirstOccurance(Configuration config, String element, String attribute, String value, boolean create) {
        Configuration[] children = config.getChildren(element);
        int i = 0;
        while (i < children.length) {
            String v = children[i].getAttribute(attribute, null);
            if (v != null && (value == null || v.equals(value))) {
                return children[i];
            }
            ++i;
        }
        return create ? new DefaultConfiguration(element, null) : null;
    }

    public static boolean equals(Configuration c1, Configuration c2) {
        return org.apache.avalon.framework.configuration.ConfigurationUtil.equals((Configuration)c1, (Configuration)c2);
    }
}

