/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration;

import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class CascadingConfiguration
implements Configuration {
    private final Configuration m_base;
    private final Configuration m_parent;

    public CascadingConfiguration(Configuration base, Configuration parent) {
        this.m_base = base == null ? new DefaultConfiguration("-", null) : base;
        this.m_parent = parent == null ? new DefaultConfiguration("-", null) : parent;
    }

    public String getName() {
        return this.m_base.getName();
    }

    public String getLocation() {
        return this.m_base.getLocation();
    }

    public String getNamespace() throws ConfigurationException {
        return this.m_base.getNamespace();
    }

    public Configuration getChild(String child) {
        return new CascadingConfiguration(this.m_base.getChild(child), this.m_parent.getChild(child));
    }

    public Configuration getChild(String child, boolean createNew) {
        if (createNew) {
            return this.getChild(child);
        }
        Configuration c = this.m_base.getChild(child, false);
        if (c != null) {
            return c;
        }
        return this.m_parent.getChild(child, false);
    }

    public Configuration[] getChildren() {
        Configuration[] b = this.m_base.getChildren();
        Configuration[] p = this.m_parent.getChildren();
        Configuration[] result = new Configuration[b.length + p.length];
        System.arraycopy(b, 0, result, 0, b.length);
        System.arraycopy(p, 0, result, b.length, p.length);
        return result;
    }

    public Configuration[] getChildren(String name) {
        Configuration[] b = this.m_base.getChildren(name);
        Configuration[] p = this.m_parent.getChildren(name);
        Configuration[] result = new Configuration[b.length + p.length];
        System.arraycopy(b, 0, result, 0, b.length);
        System.arraycopy(p, 0, result, b.length, p.length);
        return result;
    }

    public String[] getAttributeNames() {
        Vector<String> vector = new Vector<String>();
        String[] names = this.m_base.getAttributeNames();
        String[] names2 = this.m_parent.getAttributeNames();
        int i = 0;
        while (i < names.length) {
            vector.add(names[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < names2.length) {
            if (vector.indexOf(names2[i2]) < 0) {
                vector.add(names2[i2]);
            }
            ++i2;
        }
        return vector.toArray(new String[0]);
    }

    public String getAttribute(String paramName) throws ConfigurationException {
        try {
            return this.m_base.getAttribute(paramName);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttribute(paramName);
        }
    }

    public int getAttributeAsInteger(String paramName) throws ConfigurationException {
        try {
            return this.m_base.getAttributeAsInteger(paramName);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsInteger(paramName);
        }
    }

    public long getAttributeAsLong(String name) throws ConfigurationException {
        try {
            return this.m_base.getAttributeAsLong(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsLong(name);
        }
    }

    public float getAttributeAsFloat(String paramName) throws ConfigurationException {
        try {
            return this.m_base.getAttributeAsFloat(paramName);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsFloat(paramName);
        }
    }

    public boolean getAttributeAsBoolean(String paramName) throws ConfigurationException {
        try {
            return this.m_base.getAttributeAsBoolean(paramName);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsBoolean(paramName);
        }
    }

    public String getValue() throws ConfigurationException {
        try {
            return this.m_base.getValue();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValue();
        }
    }

    public int getValueAsInteger() throws ConfigurationException {
        try {
            return this.m_base.getValueAsInteger();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsInteger();
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        try {
            return this.m_base.getValueAsFloat();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsFloat();
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        try {
            return this.m_base.getValueAsBoolean();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsBoolean();
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        try {
            return this.m_base.getValueAsLong();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsLong();
        }
    }

    public String getValue(String defaultValue) {
        try {
            return this.m_base.getValue();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValue(defaultValue);
        }
    }

    public int getValueAsInteger(int defaultValue) {
        try {
            return this.m_base.getValueAsInteger();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsInteger(defaultValue);
        }
    }

    public long getValueAsLong(long defaultValue) {
        try {
            return this.m_base.getValueAsLong();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsLong(defaultValue);
        }
    }

    public float getValueAsFloat(float defaultValue) {
        try {
            return this.m_base.getValueAsFloat();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsFloat(defaultValue);
        }
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        try {
            return this.m_base.getValueAsBoolean();
        }
        catch (ConfigurationException e) {
            return this.m_parent.getValueAsBoolean(defaultValue);
        }
    }

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.m_base.getAttribute(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttribute(name, defaultValue);
        }
    }

    public int getAttributeAsInteger(String name, int defaultValue) {
        try {
            return this.m_base.getAttributeAsInteger(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsInteger(name, defaultValue);
        }
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        try {
            return this.m_base.getAttributeAsLong(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsLong(name, defaultValue);
        }
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        try {
            return this.m_base.getAttributeAsFloat(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsFloat(name, defaultValue);
        }
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.m_base.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException e) {
            return this.m_parent.getAttributeAsBoolean(name, defaultValue);
        }
    }
}

