/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.util.dag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.fortress.util.dag.CyclicDependencyException;

public final class Vertex
implements Comparable {
    private final String m_name;
    private final Object m_node;
    private int m_order;
    private boolean m_seen;
    private final List m_dependencies;

    public Vertex(Object node) {
        this(node.toString(), node);
    }

    public Vertex(String name, Object node) {
        this.m_name = name;
        this.m_node = node;
        this.m_dependencies = new ArrayList();
        this.reset();
    }

    public void reset() {
        this.m_order = 0;
        this.m_seen = false;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getNode() {
        return this.m_node;
    }

    public void addDependency(Vertex v) {
        if (!this.m_dependencies.contains(v)) {
            this.m_dependencies.add(v);
        }
    }

    public void resolveOrder() throws CyclicDependencyException {
        this.resolveOrder(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveOrder(String path) throws CyclicDependencyException {
        this.m_seen = true;
        try {
            int highOrder = -1;
            Iterator iter = this.m_dependencies.iterator();
            while (iter.hasNext()) {
                Vertex dv = (Vertex)iter.next();
                if (dv.m_seen) {
                    throw new CyclicDependencyException(path + " -> " + dv.getName());
                }
                highOrder = Math.max(highOrder, dv.resolveOrder(path + " -> " + dv.getName()));
            }
            int n = this.m_order = highOrder + 1;
            Object var6_6 = null;
            this.m_seen = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_seen = false;
            throw throwable;
        }
    }

    public List getDependencies() {
        return this.m_dependencies;
    }

    public int compareTo(Object o) {
        Vertex other = (Vertex)o;
        int orderInd = this.m_order < other.m_order ? -1 : (this.m_order > other.m_order ? 1 : 0);
        return orderInd;
    }

    public int getOrder() {
        return this.m_order;
    }
}

