/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.util.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.fortress.util.dag.CyclicDependencyException;
import org.apache.avalon.fortress.util.dag.Vertex;

public class DirectedAcyclicGraphVerifier {
    public static void verify(Vertex vertex) throws CyclicDependencyException {
        ArrayList vertices = new ArrayList();
        DirectedAcyclicGraphVerifier.addDependencies(vertex, vertices);
        DirectedAcyclicGraphVerifier.verify(vertices);
    }

    private static void addDependencies(Vertex vertex, List vertices) {
        if (!vertices.contains(vertex)) {
            vertices.add(vertex);
            Iterator iter = vertex.getDependencies().iterator();
            while (iter.hasNext()) {
                DirectedAcyclicGraphVerifier.addDependencies((Vertex)iter.next(), vertices);
            }
        }
    }

    public static void verify(List vertices) throws CyclicDependencyException {
        DirectedAcyclicGraphVerifier.resetVertices(vertices);
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            Iterator dit = v.getDependencies().iterator();
            while (dit.hasNext()) {
                Vertex dv = (Vertex)dit.next();
                if (vertices.contains(dv)) continue;
                throw new IllegalStateException("A dependent vertex (" + dv.getName() + ") of " + "vertex (" + v.getName() + ") was not included in the vertices list.");
            }
            v.resolveOrder();
        }
    }

    public static void topologicalSort(List vertices) throws CyclicDependencyException {
        DirectedAcyclicGraphVerifier.verify(vertices);
        Collections.sort(vertices);
    }

    public static void resetVertices(List vertices) {
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            ((Vertex)it.next()).reset();
        }
    }
}

