/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.fortress.tools.Component;

final class Service {
    private final Set m_components;
    private final String m_type;

    public Service(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.m_type = type;
        this.m_components = new HashSet();
    }

    public String getType() {
        return this.m_type;
    }

    public void addComponent(Component type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.m_components.add(type);
    }

    public Iterator getComponents() {
        return this.m_components.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(File rootDir) throws IOException {
        if (this.m_components.isEmpty()) {
            return;
        }
        File serviceFile = new File(rootDir, "META-INF/services/" + this.getType());
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(serviceFile));
            Iterator it = this.m_components.iterator();
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                writer.println(comp.getType());
            }
            Object var7_6 = null;
            if (null != writer) {
                writer.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null != writer) {
                writer.close();
            }
            throw throwable;
        }
    }
}

