/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.tools;

import com.thoughtworks.qdox.ant.AbstractQdoxTask;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.fortress.tools.Component;
import org.apache.avalon.fortress.tools.Service;
import org.apache.avalon.fortress.util.dag.CyclicDependencyException;
import org.apache.avalon.fortress.util.dag.DirectedAcyclicGraphVerifier;
import org.apache.avalon.fortress.util.dag.Vertex;
import org.apache.tools.ant.BuildException;

public final class ComponentMetaInfoCollector
extends AbstractQdoxTask {
    private final Map m_services = new HashMap();
    private File m_destDir;
    private File m_serviceFile;
    private static final String TAG_COMPONENT = "avalon.component";

    public void setDestDir(File destDir) {
        this.m_destDir = destDir;
    }

    public void execute() throws BuildException {
        this.validate();
        this.log("Writing Info descriptors as property files (.meta).");
        super.execute();
        try {
            try {
                this.collectInfoMetaData();
                this.writeComponents();
                this.writeServiceList(this.m_services.values().iterator());
                this.log("Collecting service information.");
                this.writeServices();
            }
            catch (Exception e) {
                throw new BuildException(e.toString(), (Throwable)e);
            }
            Object var3_1 = null;
            Component.m_repository.clear();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            Component.m_repository.clear();
            throw throwable;
        }
    }

    private void writeComponents() throws IOException, CyclicDependencyException {
        ArrayList<Vertex> dagVerifyList = new ArrayList<Vertex>(Component.m_repository.size());
        Iterator it = Component.m_repository.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            comp.serialize(this.m_destDir);
            dagVerifyList.add(comp.getVertex());
        }
        DirectedAcyclicGraphVerifier.verify(dagVerifyList);
    }

    public void writeServiceList(Iterator it) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(this.m_serviceFile));
        int numServices = 0;
        while (it.hasNext()) {
            writer.println(((Service)it.next()).getType());
            ++numServices;
        }
        writer.close();
        if (numServices == 0) {
            this.m_serviceFile.delete();
        }
    }

    private void validate() {
        if (null == this.m_destDir) {
            String message = "DestDir (" + this.m_destDir + ") not specified";
            throw new BuildException(message);
        }
        if (!this.m_destDir.isDirectory()) {
            String message = "DestDir (" + this.m_destDir + ") is not a directory.";
            throw new BuildException(message);
        }
        if (!this.m_destDir.exists() && !this.m_destDir.mkdirs()) {
            String message = "DestDir (" + this.m_destDir + ") could not be created.";
            throw new BuildException(message);
        }
        this.m_serviceFile = new File(this.m_destDir, "services.list");
    }

    private void collectInfoMetaData() {
        Iterator it = this.allClasses.iterator();
        while (it.hasNext()) {
            JavaClass javaClass = (JavaClass)it.next();
            DocletTag tag = javaClass.getTagByName(TAG_COMPONENT);
            if (null == tag) continue;
            Component comp = new Component(javaClass);
            Iterator sit = comp.getServiceNames();
            while (sit.hasNext()) {
                String servName = (String)sit.next();
                Service service = this.getService(servName);
                service.addComponent(comp);
            }
            Iterator dit = comp.getDependencyNames();
            while (dit.hasNext()) {
                String depName = (String)dit.next();
                Service service = this.getService(depName);
                comp.addDependency(service);
            }
        }
    }

    protected Service getService(String type) {
        Service service = (Service)this.m_services.get(type);
        if (null == service) {
            service = new Service(type);
            this.m_services.put(service.getType(), service);
        }
        return service;
    }

    private void writeServices() {
        File baseDir = new File(this.m_destDir, "META-INF/services/");
        baseDir.mkdirs();
        Iterator services = this.m_services.values().iterator();
        while (services.hasNext()) {
            Service service = (Service)services.next();
            this.log("Processing service " + service.getType(), 3);
            try {
                service.serialize(this.m_destDir);
            }
            catch (Exception e) {
                this.log("Could not save information for service " + service.getType(), 1);
            }
        }
    }
}

