/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.tools;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.fortress.MetaInfoEntry;
import org.apache.avalon.fortress.tools.Service;
import org.apache.avalon.fortress.util.dag.Vertex;
import org.apache.tools.ant.BuildException;

final class Component {
    private static final String SINGLE_THREADED = "org.apache.avalon.framework.thread.SingleThreaded";
    private static final String THREAD_SAFE = "org.apache.avalon.framework.thread.ThreadSafe";
    private static final String POOLABLE = "org.apache.avalon.excalibur.pool.Poolable";
    private static final String RECYCLABLE = "org.apache.avalon.excalibur.pool.Recyclable";
    private static final String SERVICE_MANAGER = "org.apache.avalon.framework.service.ServiceManager";
    static final String ATTR_TYPE = "type";
    static final String ATTR_NAME = "name";
    private static final String TAG_SERVICE = "avalon.service";
    private static final String TAG_DEPENDENCY = "avalon.dependency";
    private static final String TAG_LIFESTYLE = "x-avalon.lifestyle";
    private static final String TAG_HANDLER = "fortress.handler";
    private static final String TAG_INFO = "x-avalon.info";
    private static final String TAG_NAME = "fortress.name";
    private static final String META_NAME = "x-avalon.name";
    private static final String METH_SERVICE = "service";
    static final Set m_repository = new HashSet();
    private final JavaClass m_javaClass;
    private final Properties m_attributes;
    private final List m_dependencies;
    private final Vertex m_vertex;
    private final List m_dependencyNames;
    private final List m_serviceNames;

    public Component(JavaClass javaClass) {
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        this.m_javaClass = javaClass;
        this.m_attributes = new Properties();
        this.m_dependencies = new ArrayList(10);
        this.m_vertex = new Vertex(this);
        this.m_dependencyNames = new ArrayList(10);
        this.m_serviceNames = new ArrayList(10);
        DocletTag[] tags = javaClass.getTagsByName(TAG_SERVICE);
        int t = 0;
        while (t < tags.length) {
            if (tags[t].getNamedParameter(ATTR_TYPE) == null) {
                throw new BuildException("The \"type\" tag is missing from the \"@avalon.service\" meta tag in " + javaClass.getName());
            }
            String serviceName = this.resolveClassName(this.m_javaClass.getParentSource(), tags[t].getNamedParameter(ATTR_TYPE));
            this.m_serviceNames.add(serviceName);
            ++t;
        }
        this.discoverLifecycleType();
        this.discoverNameInfo();
        this.discoverDependencies();
        m_repository.add(this);
    }

    private void discoverDependencies() {
        JavaClass currClass = this.m_javaClass;
        while (currClass != null && this.discoverDependencies(currClass)) {
            currClass = currClass.getSuperJavaClass();
        }
    }

    private boolean discoverDependencies(JavaClass fromClass) {
        boolean isSuccessful = true;
        JavaMethod[] methods = fromClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(METH_SERVICE) && methods[i].getParameters().length == 1 && methods[i].getParameters()[0].getType().getValue().equals(SERVICE_MANAGER)) {
                DocletTag[] dependencies = methods[i].getTagsByName(TAG_DEPENDENCY);
                int d = 0;
                while (d < dependencies.length) {
                    if (dependencies[d].getNamedParameter(ATTR_TYPE) == null) {
                        throw new BuildException("The \"type\" tag is missing from a \"@avalon.dependency\" meta tag of the service method in " + fromClass.getName());
                    }
                    String type = this.resolveClassName(fromClass.getParentSource(), dependencies[d].getNamedParameter(ATTR_TYPE));
                    if (null == type) {
                        isSuccessful = false;
                    } else {
                        this.m_dependencyNames.add(type);
                    }
                    ++d;
                }
            }
            ++i;
        }
        return isSuccessful;
    }

    private void discoverNameInfo() {
        DocletTag avalonConfigName = this.m_javaClass.getTagByName(TAG_INFO);
        if (null == avalonConfigName) {
            avalonConfigName = this.m_javaClass.getTagByName(TAG_NAME);
        }
        this.setAttribute(META_NAME, avalonConfigName == null ? MetaInfoEntry.createShortName(this.m_javaClass.getName()) : avalonConfigName.getNamedParameter(ATTR_NAME));
    }

    private void discoverLifecycleType() {
        DocletTag avalonLifecycle = this.m_javaClass.getTagByName(TAG_LIFESTYLE);
        DocletTag fortressHandler = this.m_javaClass.getTagByName(TAG_HANDLER);
        String lifecycle = null;
        String handler = null;
        if (avalonLifecycle == null && fortressHandler == null) {
            Type[] interfaces = this.m_javaClass.getImplements();
            int i = 0;
            while (i < interfaces.length && handler != null) {
                if (interfaces[i].getClass().getName().equals(THREAD_SAFE)) {
                    handler = "org.apache.avalon.fortress.impl.handler.ThreadSafeComponentHandler";
                } else if (interfaces[i].getClass().getName().equals(POOLABLE) || interfaces[i].getClass().getName().equals(RECYCLABLE)) {
                    handler = "org.apache.avalon.fortress.impl.handler.PoolableComponentHandler";
                } else if (interfaces[i].getClass().getName().equals(SINGLE_THREADED)) {
                    handler = "org.apache.avalon.fortress.impl.handler.FactoryComponentHandler";
                }
                ++i;
            }
        }
        if (null != avalonLifecycle) {
            lifecycle = this.stripQuotes(avalonLifecycle.getNamedParameter(ATTR_TYPE));
        } else if (handler != null) {
            String string = handler = null == fortressHandler ? "org.apache.avalon.fortress.impl.handler.PerThreadComponentHandler" : this.stripQuotes(fortressHandler.getNamedParameter(ATTR_TYPE));
        }
        if (null != lifecycle) {
            this.setAttribute(TAG_LIFESTYLE, lifecycle);
        }
        if (null != handler) {
            this.setAttribute(TAG_HANDLER, handler);
        }
    }

    public String getType() {
        return this.m_javaClass.getFullyQualifiedName();
    }

    public Iterator getDependencyNames() {
        return this.m_dependencyNames.iterator();
    }

    public Iterator getServiceNames() {
        return this.m_serviceNames.iterator();
    }

    public void addDependency(Service service) {
        if (!this.m_dependencies.contains(service)) {
            this.m_dependencies.add(service);
        }
    }

    public Vertex getVertex() {
        if (this.m_vertex.getDependencies().size() != 0) {
            Iterator it = this.m_dependencies.iterator();
            while (it.hasNext()) {
                Service service = (Service)it.next();
                Iterator cit = service.getComponents();
                while (cit.hasNext()) {
                    Component component = (Component)cit.next();
                    this.m_vertex.addDependency(component.getVertex());
                }
            }
        }
        return this.m_vertex;
    }

    public void setAttribute(String name, String value) {
        this.m_attributes.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(File rootDir) throws IOException {
        String fileName = this.getType().replace('.', '/').concat(".meta");
        String depsName = this.getType().replace('.', '/').concat(".deps");
        File output = new File(rootDir, fileName);
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(output);
            this.m_attributes.store(writer, "Meta information for " + this.getType());
            if (this.m_dependencies.size() > 0) {
                writer.close();
                output = new File(rootDir, depsName);
                writer = new FileOutputStream(output);
                Iterator it = this.m_dependencies.iterator();
                while (it.hasNext()) {
                    Service service = (Service)it.next();
                    String name = service.getType() + "\n";
                    writer.write(name.getBytes());
                }
            }
            Object var10_9 = null;
            if (null == writer) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == writer) throw throwable;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    private String stripQuotes(String value) {
        if (null == value) {
            return null;
        }
        if (value.length() < 2) {
            return value;
        }
        String retVal = value.trim();
        if (retVal.startsWith("\"") && retVal.endsWith("\"")) {
            retVal = retVal.substring(1, retVal.length() - 1);
        }
        return retVal;
    }

    protected String resolveClassName(JavaSource sourceCode, String serviceName) {
        if (null == sourceCode) {
            return null;
        }
        if (null == serviceName) {
            throw new IllegalStateException("The serviceName parameter was null.");
        }
        String className = this.stripQuotes(serviceName);
        if ((className != null || className.length() > 0) && className.indexOf(46) < 0) {
            String checkName = this.checkPackage(sourceCode, sourceCode.getPackage(), className);
            if (!checkName.equals(className)) {
                return checkName;
            }
            String[] imports = sourceCode.getImports();
            int t = 0;
            while (t < imports.length) {
                checkName = this.checkImport(sourceCode, imports[t], className);
                if (!checkName.equals(className)) {
                    return checkName;
                }
                ++t;
            }
        }
        return className;
    }

    private String checkImport(JavaSource sourceCode, String type, String className) {
        String pack;
        String checkName;
        String tail = type.substring(type.lastIndexOf(46) + 1);
        if (tail.equals(className)) {
            return type;
        }
        if (tail.equals("*") && !(checkName = this.checkPackage(sourceCode, pack = type.substring(0, type.lastIndexOf(46)), className)).equals(className)) {
            return checkName;
        }
        return className;
    }

    private String checkPackage(JavaSource sourceCode, String pack, String serviceName) {
        String className = serviceName;
        JavaClass klass = sourceCode.getClassLibrary().getClassByName(pack + "." + serviceName);
        if (null != klass) {
            className = klass.getFullyQualifiedName();
        }
        return className;
    }
}

