/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.impl.role;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.fortress.MetaInfoManager;
import org.apache.avalon.fortress.RoleManager;
import org.apache.avalon.fortress.impl.role.AbstractMetaInfoManager;
import org.apache.avalon.fortress.util.Service;
import org.apache.avalon.framework.activity.Initializable;

public final class ServiceMetaManager
extends AbstractMetaInfoManager
implements Initializable {
    public ServiceMetaManager() {
        super((MetaInfoManager)null);
    }

    public ServiceMetaManager(RoleManager parent) {
        super(parent);
    }

    public ServiceMetaManager(MetaInfoManager parent) {
        super(parent);
    }

    public ServiceMetaManager(MetaInfoManager parent, ClassLoader loader) {
        super(parent, loader);
    }

    public void initialize() throws Exception {
        HashSet services = new HashSet();
        Enumeration<URL> enumeration = this.getLoader().getResources("services.list");
        while (enumeration.hasMoreElements()) {
            this.readEntries(services, enumeration.nextElement());
        }
        Iterator it = services.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            this.getLogger().debug("Adding service: " + role);
            try {
                this.setupImplementations(role);
            }
            catch (Exception e) {
                this.getLogger().debug("Specified service '" + role + "' is not available", (Throwable)e);
            }
        }
    }

    private void setupImplementations(String role) throws ClassNotFoundException {
        Iterator it = Service.providers(this.getLoader().loadClass(role));
        while (it.hasNext()) {
            String impl = ((Class)it.next()).getName();
            this.getLogger().debug("Reading meta info for " + impl);
            if (!this.isAlreadyAdded(impl)) {
                this.readMeta(role, impl);
                continue;
            }
            this.addComponent(role, impl, null, null);
        }
    }

    private void readMeta(String role, String implementation) {
        Properties meta = new Properties();
        ArrayList deps = new ArrayList();
        try {
            meta.load(this.getLoader().getResourceAsStream(this.getMetaFile(implementation)));
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not load meta information for " + implementation + ", skipping this class.");
            return;
        }
        try {
            URL depURL = this.getLoader().getResource(this.getDepFile(implementation));
            if (depURL == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("No dependencies for " + implementation + ".");
                }
            } else {
                HashSet set = new HashSet();
                this.readEntries(set, depURL);
                deps.addAll(set);
            }
        }
        catch (Exception ioe) {
            this.getLogger().debug("Could not load dependencies for " + implementation + ".", (Throwable)ioe);
        }
        this.addComponent(role, implementation, meta, deps);
    }

    private String getMetaFile(String implementation) {
        String entry = implementation.replace('.', '/');
        entry = entry + ".meta";
        return entry;
    }

    private String getDepFile(String implementation) {
        String entry = implementation.replace('.', '/');
        entry = entry + ".deps";
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntries(Set entries, URL url) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            String entry = reader.readLine();
            while (entry != null) {
                entries.add(entry);
                entry = reader.readLine();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }
}

