/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.fortress.RoleEntry;

public final class MetaInfoEntry {
    public static final String THREADSAFE_HANDLER = "org.apache.avalon.fortress.impl.handler.ThreadSafeComponentHandler";
    public static final String POOLABLE_HANDLER = "org.apache.avalon.fortress.impl.handler.PoolableComponentHandler";
    public static final String FACTORY_HANDLER = "org.apache.avalon.fortress.impl.handler.FactoryComponentHandler";
    public static final String PER_THREAD_HANDLER = "org.apache.avalon.fortress.impl.handler.PerThreadComponentHandler";
    private final Class m_klass;
    private final String m_configName;
    private final Class m_handler;
    private final Set m_roles;
    private volatile boolean m_readOnly = false;
    private static final Map m_lifecycleMap;
    private final List m_dependencies;
    private static final String TYPE_SINGLETON = "singleton";
    private static final String TYPE_THREAD = "thread";
    private static final String TYPE_POOLED = "pooled";
    private static final String TYPE_TRANSIENT = "transient";

    public MetaInfoEntry(Class componentClass, Properties properties, List deps) throws ClassNotFoundException {
        if (null == componentClass) {
            throw new NullPointerException("\"componentClass\" cannot be null.");
        }
        if (null == properties) {
            throw new NullPointerException("\"properties\" cannot be null.");
        }
        if (null == deps) {
            throw new NullPointerException("\"deps\" cannot be null.");
        }
        this.m_klass = componentClass;
        this.m_configName = properties.getProperty("x-avalon.name", MetaInfoEntry.createShortName(componentClass.getName()));
        this.m_handler = Thread.currentThread().getContextClassLoader().loadClass(this.getHandler(properties));
        this.m_roles = new HashSet();
        this.m_dependencies = deps;
    }

    public MetaInfoEntry(RoleEntry roleEntry) {
        if (null == roleEntry) {
            throw new NullPointerException("\"roleEntry\" cannot be null.");
        }
        this.m_klass = roleEntry.getComponentClass();
        this.m_configName = roleEntry.getShortname();
        this.m_handler = roleEntry.getHandlerClass();
        this.m_roles = new HashSet();
        this.m_roles.add(roleEntry.getRole());
        this.m_dependencies = new ArrayList();
        this.makeReadOnly();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public Class getComponentClass() {
        return this.m_klass;
    }

    public Class getHandlerClass() {
        return this.m_handler;
    }

    public String getConfigurationName() {
        return this.m_configName;
    }

    public void addRole(String role) {
        if (null == role) {
            throw new NullPointerException("\"role\" cannot be null");
        }
        if (this.m_readOnly) {
            throw new SecurityException("This MetaInfoEntry is read-only.");
        }
        this.m_roles.add(role);
    }

    public boolean containsRole(String role) {
        if (null == role) {
            throw new NullPointerException("\"role\" cannot be null");
        }
        return this.m_roles.contains(role);
    }

    public Iterator getRoles() {
        return this.m_roles.iterator();
    }

    public List getDependencies() {
        return this.m_dependencies;
    }

    private String getHandler(Properties meta) {
        String lifecycle = meta.getProperty("x-avalon.lifestyle", null);
        String handler = null != lifecycle ? (String)m_lifecycleMap.get(lifecycle) : meta.getProperty("fortress.handler");
        if (null == handler) {
            handler = PER_THREAD_HANDLER;
        }
        return handler;
    }

    public static final String createShortName(String className) {
        StringBuffer shortName = new StringBuffer();
        char[] name = className.substring(className.lastIndexOf(46) + 1).toCharArray();
        char last = '\u0000';
        int i = 0;
        while (i < name.length) {
            if (Character.isUpperCase(name[i])) {
                if (Character.isLowerCase(last)) {
                    shortName.append('-');
                }
                shortName.append(Character.toLowerCase(name[i]));
            } else {
                shortName.append(name[i]);
            }
            last = name[i];
            ++i;
        }
        return shortName.toString().toLowerCase();
    }

    static {
        HashMap<String, String> lifecycleMap = new HashMap<String, String>();
        lifecycleMap.put(TYPE_SINGLETON, THREADSAFE_HANDLER);
        lifecycleMap.put(TYPE_THREAD, PER_THREAD_HANDLER);
        lifecycleMap.put(TYPE_POOLED, POOLABLE_HANDLER);
        lifecycleMap.put(TYPE_TRANSIENT, FACTORY_HANDLER);
        m_lifecycleMap = Collections.unmodifiableMap(lifecycleMap);
    }
}

