/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.fortress.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ChangedFileOutputStream
extends OutputStream {
    private File m_file;
    private ByteArrayOutputStream m_bos;

    public ChangedFileOutputStream(File file) {
        this.m_file = file;
        this.m_bos = new ByteArrayOutputStream();
    }

    public void write(int b) throws IOException {
        this.m_bos.write(b);
    }

    public void close() throws IOException {
        boolean changed;
        byte[] newContent = this.m_bos.toByteArray();
        this.m_bos.close();
        if (this.m_file.exists()) {
            byte[] oldContent = this.readBytes(this.m_file);
            if (newContent.length != oldContent.length) {
                changed = true;
            } else {
                changed = false;
                for (int i = 0; i < newContent.length; ++i) {
                    if (newContent[i] == oldContent[i]) continue;
                    changed = true;
                    break;
                }
            }
        } else {
            changed = true;
        }
        if (changed) {
            this.writeBytes(this.m_file, newContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream is = new FileInputStream(file);
        try {
            int read;
            for (int pos = 0; pos < bytes.length && (read = is.read(bytes, pos, bytes.length - pos)) >= 0; pos += read) {
            }
        }
        finally {
            is.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytes(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            os.write(bytes, 0, bytes.length);
        }
        finally {
            os.close();
        }
    }
}

