/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.web;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

class GenerateCommandsDoclet {
    private static final String FS = File.separator;
    private static final String SOURCE_DIR = System.getProperty("user.dir") + FS + "src" + FS + "java" + FS + "com" + FS + "exoftware" + FS + "exactor" + FS + "command" + FS + "web" + FS;
    private static final String JAVA_TEMPLATE = "package com.exoftware.exactor.command.web;\n\n/**\n * Command wrapping jwebunit <code>WebTester.{0}( {1} }</code>.\n *\n * Usage example;\n * <pre>\n *  <code>\n *      {2} {3}\n *  </code>\n * </pre>\n *\n * @author Brian Swan\n */\npublic class {2} extends WebCommand\n'{'\n    /**\n     * Execute the command. {4}\n     *\n     * @throws Exception is an error occurs.\n     */\n    public void execute() throws Exception\n    '{'\n        getWebTester().{0}( {5} );\n    '}'\n'}'";

    GenerateCommandsDoclet() {
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classes = root.classes();
        if (classes.length == 1 && classes[0].name().equals("WebTester")) {
            MethodDoc[] methods = classes[0].methods();
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].name();
                String parameterTypes = GenerateCommandsDoclet.getParameterTypes(methods[i].parameters());
                String className = GenerateCommandsDoclet.toClassName(methodName);
                String parameterNames = GenerateCommandsDoclet.getParameterNames(methods[i].parameters(), " ");
                String docCommenr = GenerateCommandsDoclet.getDocComment(methods[i].commentText(), methods[i].parameters());
                String parameterCalls = GenerateCommandsDoclet.getParameterCalls(methods[i].parameters());
                String[] replacements = new String[]{methodName, parameterTypes, className, parameterNames, docCommenr, parameterCalls};
                if (!methods[i].isPublic() || parameterCalls == null) continue;
                GenerateCommandsDoclet.createJavaFile(replacements);
            }
        }
        return true;
    }

    private static void createJavaFile(String[] replacements) {
        try {
            FileWriter writer = new FileWriter(SOURCE_DIR + replacements[2] + ".java");
            writer.write(MessageFormat.format(JAVA_TEMPLATE, replacements));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Unable to create java file. " + e.getMessage());
        }
    }

    private static String getParameterCalls(Parameter[] parameters) {
        ArrayList<String> calls = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Type type = parameters[i].type();
            if (type.typeName().equals("String") && type.dimension().equals("")) {
                calls.add("getParameter( " + i + " ).stringValue()");
                continue;
            }
            if (type.typeName().equals("int") && type.dimension().equals("")) {
                calls.add("getParameter( " + i + " ).intValue()");
                continue;
            }
            return null;
        }
        return GenerateCommandsDoclet.seperateWithChar(calls, ", ");
    }

    private static String getDocComment(String comment, Parameter[] parameters) {
        StringBuffer result = new StringBuffer(comment);
        if (comment.startsWith("Assert")) {
            result.replace(0, "Assert".length(), "Check");
        }
        result.append("\n");
        result.append("     * ");
        switch (parameters.length) {
            case 1: {
                result.append("One parameter is expected, ");
                break;
            }
            case 2: {
                result.append("Two parameters are expected, ");
                break;
            }
            case 3: {
                result.append("Three parameters are expected, ");
                break;
            }
            default: {
                result.append("One or three parameters are expected, ");
            }
        }
        result.append(GenerateCommandsDoclet.getParameterNames(parameters, ", "));
        result.append(".");
        return result.toString();
    }

    private static String getParameterNames(Parameter[] parameters, String separator) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            names.add(parameters[i].name());
        }
        return GenerateCommandsDoclet.seperateWithChar(names, separator);
    }

    private static String toClassName(String methodName) {
        if (methodName.startsWith("assert")) {
            return "Check" + methodName.substring("assert".length());
        }
        if (methodName.startsWith("check")) {
            return "Select" + methodName.substring("check".length());
        }
        if (methodName.startsWith("uncheck")) {
            return "Deselect" + methodName.substring("uncheck".length());
        }
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    private static String getParameterTypes(Parameter[] parameters) {
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            types.add(parameters[i].type().typeName());
        }
        return GenerateCommandsDoclet.seperateWithChar(types, ", ");
    }

    private static String seperateWithChar(List types, String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < types.size(); ++i) {
            result.append((String)types.get(i));
            if (i == types.size() - 1) continue;
            result.append(s);
        }
        return result.toString();
    }
}

