/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.abbot;

import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.finder.TestHierarchy;
import abbot.script.ComponentReference;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.Script;
import abbot.script.Step;
import abbot.script.StepRunner;
import com.exoftware.exactor.command.abbot.Util;
import com.exoftware.exactor.command.swing.AbstractSwingCommand;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class AbstractAbbotCommand
extends AbstractSwingCommand {
    public static final String ABBOT_SCRIPT_KEY = "AbbotScript";
    public static final String ABBOT_STEP_RUNNER_KEY = "AbbotStepRunner";

    public void execute() throws Exception {
        try {
            this.getStepRunner().run(this.createStep(this.getAbbotScript(), this.buildAbbotXml(this.getTemplateXML())));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Abbot Run Exception: ", throwable);
        }
    }

    protected Step createStep(Script script, String str) throws InvalidScriptException, IOException {
        return Step.createStep((Resolver)script, (String)str);
    }

    Script getAbbotScript() {
        if (this.getScript().getContext().get(ABBOT_SCRIPT_KEY) == null) {
            TestHierarchy testHierarchy = new TestHierarchy(true);
            Script abbotScript = new Script((Hierarchy)testHierarchy);
            AWTHierarchy.setDefault((Hierarchy)testHierarchy);
            abbotScript.setAWTMode(false);
            System.setProperty("abbot.robot.verify", "false");
            this.getScript().getContext().put(ABBOT_SCRIPT_KEY, abbotScript);
        }
        return (Script)this.getScript().getContext().get(ABBOT_SCRIPT_KEY);
    }

    protected String buildAbbotXml(String abbotXML) throws Exception {
        return this.createAbbotXML(abbotXML, this.getReplacementDefinitions());
    }

    protected String createAbbotXML(String abbotXML, ReplacementDefinition[] replacementDefinitions) throws Exception {
        Element element = Util.createElement(abbotXML);
        for (int i = 0; i < replacementDefinitions.length; ++i) {
            ReplacementDefinition replacementDefinition = replacementDefinitions[i];
            String paramValue = this.getParameter(replacementDefinition.exactorParameterPosition, replacementDefinition.defaultParameterValue).stringValue();
            this.doReplacementIfPresent(element, replacementDefinition.xmlAttribute, paramValue);
        }
        return this.toString(element);
    }

    protected void doReplacementIfPresent(Element abbotXML, String attribName, String attribValue) {
        if (attribValue.length() != 0) {
            abbotXML.setAttribute(attribName, attribValue);
        } else {
            abbotXML.removeAttribute(attribName);
        }
    }

    private String toString(Element element) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter();
        StringWriter stringWriter = new StringWriter();
        xmlOutputter.output(element, (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected abstract ReplacementDefinition[] getReplacementDefinitions();

    protected abstract String getTemplateXML();

    protected void findAndLoadComponent() {
        try {
            Component component = this.findComponent(this.extractComponentName());
            if (component != null) {
                ComponentReference componentReference = new ComponentReference((Resolver)this.getAbbotScript(), component);
                this.getAbbotScript().addComponentReference(componentReference);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String extractComponentName() {
        return this.getParameter(2).stringValue().split(",")[0];
    }

    StepRunner getStepRunner() {
        if (this.getScript().getContext().get(ABBOT_STEP_RUNNER_KEY) == null) {
            this.getScript().getContext().put(ABBOT_STEP_RUNNER_KEY, new StepRunner(AWTHierarchy.getDefault()));
        }
        return (StepRunner)this.getScript().getContext().get(ABBOT_STEP_RUNNER_KEY);
    }

    protected Container[] getContainers() {
        Script abbotScript = (Script)this.getScript().getContext().get(ABBOT_SCRIPT_KEY);
        Collection roots = abbotScript.getHierarchy().getRoots();
        return roots.toArray(new Container[0]);
    }

    class ReplacementDefinition {
        int exactorParameterPosition = -1;
        String defaultParameterValue = "";
        String xmlAttribute = "";

        public ReplacementDefinition(int exactorParameterPosition, String defaultParameterValue, String xmlAttribute) {
            this.exactorParameterPosition = exactorParameterPosition;
            this.defaultParameterValue = defaultParameterValue;
            this.xmlAttribute = xmlAttribute;
        }
    }
}

