/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.abbot;

import abbot.Log;
import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.finder.TestHierarchy;
import abbot.script.Script;
import abbot.script.Step;
import abbot.script.StepRunner;
import com.exoftware.exactor.Command;
import junit.extensions.abbot.AWTFixtureHelper;

public class RunAbbotScript
extends Command {
    private AWTFixtureHelper helper;
    private Hierarchy hierarchy;

    public void execute() throws Exception {
        String filename = this.getParameter(0).stringValue();
        this.setUp(filename);
        try {
            this.runScript(filename);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error running: " + filename, throwable);
        }
        this.tearDown();
    }

    protected void setUp(String filename) {
        this.helper = new AWTFixtureHelper();
        boolean hasLaunch = new Script(filename, (Hierarchy)new AWTHierarchy()).hasLaunch();
        this.hierarchy = new TestHierarchy(hasLaunch);
        AWTHierarchy.setDefault((Hierarchy)this.hierarchy);
    }

    protected void tearDown() {
        this.hierarchy = null;
        AWTHierarchy.setDefault(null);
        this.helper.restore();
        this.helper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScript(String filename) throws Throwable {
        Script script = new Script(filename, this.hierarchy);
        Log.log((String)("Running " + script + " with " + ((Object)((Object)this)).getClass()));
        StepRunner runner = new StepRunner(this.hierarchy);
        try {
            runner.run((Step)script);
        }
        finally {
            Log.log((String)(script.toString() + " finished"));
        }
    }
}

