/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.abbot;

import abbot.script.InvalidScriptException;
import abbot.script.Step;
import abbot.script.StepRunner;
import com.exoftware.exactor.Parameter;
import com.exoftware.exactor.Script;
import com.exoftware.exactor.command.abbot.AbbotAction;
import com.exoftware.util.QuotedStringTokenizer;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import junit.framework.TestCase;

public class AbbotActionTest
extends TestCase {
    private Script script;

    protected void setUp() throws Exception {
        super.setUp();
        this.script = new Script();
        this.script.getContext().put("AbbotStepRunner", this.getStepRunner());
    }

    public void testXMLActionCreation() throws Exception {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println("*** TEST IGNORED BECAUSE NO UI AVAILABLE!!!");
            return;
        }
        this.assertActionXml("\"\" \"actionClick\" \"?\" ", "<action method=\"actionClick\" args=\"?\" />");
        this.assertActionXml("\"\" \"actionClick\" \"High Button\" ", "<action method=\"actionClick\" args=\"High Button\" />");
        this.assertActionXml("\"\" \"actionClick\" \"Low Button\" ", "<action method=\"actionClick\" args=\"Low Button\" />");
        this.assertActionXml("\"\" \"actionSelectMenuItem\" \"New Script...\" ", "<action method=\"actionSelectMenuItem\" args=\"New Script...\" />");
        this.assertActionXml("\"\" \"actionSelectMenuItem\" \"Run To\" ", "<action method=\"actionSelectMenuItem\" args=\"Run To\" />");
        this.assertActionXml("\"\" \"actionKeyStroke\" \"VK_ESCAPE\" ", "<action method=\"actionKeyStroke\" args=\"VK_ESCAPE\" />");
        this.assertActionXml("\"java.awt.Dialog\" \"actionClose\" \"Dialog\" ", "<action class=\"java.awt.Dialog\" method=\"actionClose\" args=\"Dialog\" />");
        this.assertActionXml("\"java.awt.TextComponent\" \"actionFocus\" \"textField\" ", "<action class=\"java.awt.TextComponent\" method=\"actionFocus\" args=\"textField\" />");
        this.assertActionXml("\"javax.swing.AbstractButton\" \"actionClick\" \"OK\" ", "<action class=\"javax.swing.AbstractButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXml("\"javax.swing.AbstractButton\" \"actionClick\" \"Select Test Suite...\" ", "<action class=\"javax.swing.AbstractButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Button\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Button\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"OK Button\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK Button\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"OK\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"OK\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"OK\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"OK\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Run\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Run\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Run\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Run\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXml("\"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\" ", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXml("\"javax.swing.JComboBox\" \"actionSelectItem\" \"JComboBox Instance,Combo 10\" ", "<action class=\"javax.swing.JComboBox\" method=\"actionSelectItem\" args=\"JComboBox Instance,Combo 10\" />");
        this.assertActionXml("\"javax.swing.JComboBox\" \"actionSelectItem\" \"JComboBox Instance,Combo 10\" ", "<action class=\"javax.swing.JComboBox\" method=\"actionSelectItem\" args=\"JComboBox Instance,Combo 10\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\" ", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\" ", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\" ", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\" ", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,-1,-1,Blue\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,-1,-1,Blue\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,-1,-1,Blue\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,-1,-1,Blue\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,Blue\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,Blue\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,Blue\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,Blue\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,-1,-1,Black\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,-1,-1,Black\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,-1,-1,White\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,-1,-1,White\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,Black\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,Black\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,Black\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,Black\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,White\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,White\" />");
        this.assertActionXml("\"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,White\" ", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,White\" />");
        this.assertActionXml("\"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\" ", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXml("\"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\" ", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXml("\"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\" ", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXml("\"javax.swing.JList\" \"actionSelectIndex\" \"My List,0\" ", "<action class=\"javax.swing.JList\" method=\"actionSelectIndex\" args=\"My List,0\" />");
        this.assertActionXml("\"javax.swing.JList\" \"actionSelectIndex\" \"My List,7\" ", "<action class=\"javax.swing.JList\" method=\"actionSelectIndex\" args=\"My List,7\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXml("\"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\" ", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXml("\"javax.swing.JTable\" \"actionSelectCell\" \"ScriptTable Instance,8,0\" ", "<action class=\"javax.swing.JTable\" method=\"actionSelectCell\" args=\"ScriptTable Instance,8,0\" />");
        this.assertActionXml("\"javax.swing.JTextField\" \"actionClick\" \"My Text Field,3,7\" ", "<action class=\"javax.swing.JTextField\" method=\"actionClick\" args=\"My Text Field,3,7\" />");
        this.assertActionXml("\"javax.swing.JTextField\" \"actionClick\" \"My Text Field,3,7\" ", "<action class=\"javax.swing.JTextField\" method=\"actionClick\" args=\"My Text Field,3,7\" />");
        this.assertActionXml("\"javax.swing.JTextField\" \"actionText\" \"My Text Field,Get outta here\" ", "<action class=\"javax.swing.JTextField\" method=\"actionText\" args=\"My Text Field,Get outta here\" />");
        this.assertActionXml("\"javax.swing.JTextField\" \"actionText\" \"My Text Field,Get outta here\" ", "<action class=\"javax.swing.JTextField\" method=\"actionText\" args=\"My Text Field,Get outta here\" />");
    }

    private void assertActionXml(String params, String expectedXML) throws Exception {
        MyAbbotAction runAbbotCommand = new MyAbbotAction();
        runAbbotCommand.setScript(this.script);
        String expectedActionXML = expectedXML;
        QuotedStringTokenizer toker = new QuotedStringTokenizer(params, " ");
        while (toker.hasMoreTokens()) {
            runAbbotCommand.addParameter(new Parameter(toker.nextToken()));
        }
        runAbbotCommand.execute();
        AbbotActionTest.assertEquals((String)expectedActionXML, (String)runAbbotCommand.actualActionXML);
        AbbotActionTest.assertEquals((String)this.extractComponentName(runAbbotCommand), (String)runAbbotCommand.actualComponentName);
        AbbotActionTest.assertTrue((boolean)((MyStepRunner)runAbbotCommand.getStepRunner()).runCalled);
    }

    private String extractComponentName(MyAbbotAction runAbbotCommand) {
        return runAbbotCommand.getParameter(2).stringValue().split(",")[0];
    }

    private StepRunner getStepRunner() {
        return new MyStepRunner();
    }

    private static class MyStepRunner
    extends StepRunner {
        boolean runCalled = false;

        private MyStepRunner() {
        }

        public void run(Step step) throws Throwable {
            this.runCalled = true;
        }
    }

    private static class MyAbbotAction
    extends AbbotAction {
        String actualActionXML = "";
        String actualComponentName = "";

        private MyAbbotAction() {
        }

        protected Step createStep(abbot.script.Script script, String str) throws InvalidScriptException, IOException {
            this.actualActionXML = str;
            return super.createStep(script, str);
        }

        public Component findComponent(String name) {
            this.actualComponentName = name;
            return new Component(){};
        }
    }
}

