/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.abbot.aliasgenerator;

import com.exoftware.exactor.command.abbot.Util;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;

public class AbbotAliasGenerator {
    public static final String ALIAS_TEMPLATE = "Alias         COMMAND        \"AbbotAction \\\"SWING_COMPONENT\\\" \\\"COMPONENT_ACTION\\\" \\\"[0]\\\"\"";
    public static final String ALIAS_PROP_TEMPLATE = "COMMAND=AbbotAction \\\"SWING_COMPONENT\\\" \\\"COMPONENT_ACTION\\\" \\\"[0]\\\"";
    public static final String METHOD_PREFIX = "action";

    public static Properties loadTesters() throws IOException {
        Properties props = new Properties();
        props.load(AbbotAliasGenerator.class.getResourceAsStream("components.properties"));
        return props;
    }

    public static void main(String[] args) {
        try {
            AbbotAliasGenerator.generateAliases();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void generateAliases() throws IOException, ClassNotFoundException {
        Properties testers = AbbotAliasGenerator.loadTesters();
        HashSet aliasesComposite = new HashSet();
        HashSet aliasesProperties = new HashSet();
        for (String string : testers.keySet()) {
            AbbotAliasGenerator.processClass(string, Util.resolveTester(string), aliasesComposite, aliasesProperties);
        }
    }

    private static void processClass(String componentClazzName, String testerClazzName, HashSet aliasesComposite, HashSet aliasesEile) throws ClassNotFoundException, IOException {
        Class<?> testerClazz = Class.forName(testerClazzName);
        ArrayList actionMethods = AbbotAliasGenerator.extractActionMethods(testerClazz);
        for (String action : actionMethods) {
            String alias = AbbotAliasGenerator.buildAlias(AbbotAliasGenerator.extractSwingComponent(componentClazzName), testerClazzName, action);
            aliasesComposite.add(alias);
            aliasesEile.add(AbbotAliasGenerator.buildAliasProperty(AbbotAliasGenerator.extractSwingComponent(componentClazzName), action));
        }
        AbbotAliasGenerator.writeAliases(AbbotAliasGenerator.sortAliases(aliasesComposite), "LoadAbbotAliases.cmp");
        AbbotAliasGenerator.writeAliases(AbbotAliasGenerator.sortAliases(aliasesEile), "aliases.properties");
    }

    private static String buildAliasProperty(String component, String action) {
        return component + "." + action.substring(METHOD_PREFIX.length());
    }

    private static void writeAliases(ArrayList sorted, String fileName) throws IOException {
        FileWriter fileWriter = new FileWriter(fileName);
        for (String s : sorted) {
            fileWriter.write(s + "\n");
        }
        fileWriter.close();
    }

    private static ArrayList sortAliases(HashSet aliases) {
        ArrayList sorted = new ArrayList(aliases);
        Collections.sort(sorted);
        return sorted;
    }

    private static String buildAlias(String component, String testerName, String action) {
        String alias = ALIAS_TEMPLATE;
        alias = alias.replaceAll("COMMAND", component + "." + action.substring(METHOD_PREFIX.length()));
        alias = alias.replaceAll("SWING_COMPONENT", testerName);
        alias = alias.replaceAll("COMPONENT_ACTION", action);
        return alias;
    }

    private static ArrayList extractActionMethods(Class clazz) {
        ArrayList<String> actionMethods = new ArrayList<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().startsWith(METHOD_PREFIX)) continue;
            actionMethods.add(method.getName());
        }
        return actionMethods;
    }

    private static String extractSwingComponent(String fullyQualifiedClazzName) {
        String[] strings = fullyQualifiedClazzName.split("[.]");
        String clazzName = strings[strings.length - 1];
        if (clazzName.endsWith("Tester")) {
            return clazzName.substring(0, clazzName.length() - 6);
        }
        return clazzName;
    }
}

